#include <cassert>
 #include <cstdio>
 #include <cstring>
 #include <vector>
 
 
 std::vector< std::vector<int> > path(int k, int c)
 {
 	if(c == 1)
 	{
 		std::vector< std::vector<int> > r(k);
 		for(int i = 0; i < k; i++)
 			r[i].push_back(i);
 		return r;
 	}
 	else if(k == 1)
 	{
 		return std::vector< std::vector<int> >(1, std::vector<int>(c, 0));
 	}
 	else
 	{
 		std::vector< std::vector<int> > r = path(k - 1, c - 1);
 		for(int i = 0; i < (int)r.size(); i++)
 			r[i].push_back(k - 1);
 		return r;
 	}
 }
 
 long long index(const std::vector<int> & p, const long long k)
 {
 	long long r = 0;
 	long long m = 1;
 	for(int i = 0; i < (int)p.size(); i++)
 	{
 		r += m * p[i];
 		m *= k;
 	}
 	return r + 1;
 }
 
 int main()
 {
 	int tests;
 	scanf("%i", &tests);
 	for(int t = 1; t <= tests; t++)
 	{
 		printf("Case #%i:", t);
 
 		int k, c, s;
 		scanf("%i %i %i", &k, &c, &s);
 		
 		std::vector< std::vector<int> > r = path(k, c);
 		
 		if(s < (int)r.size())
 		{
 			printf(" IMPOSSIBLE");
 		}
 		else
 		{
 			for(int i = 0; i < (int)r.size(); i++)
 			{
 				assert(c == (int)r[i].size());
 				printf(" %lli", index(r[i], k));
 			}
 		}
 
 		printf("\n");	
 	}
 	
 	return 0;
 }
 
