//
 //  main.c
 //  CodeJAm_2016_eliminatoria_4
 //
 //  Created by Otávio Netto Zani on 09/04/16.
 //  Copyright © 2016 Otávio Netto Zani. All rights reserved.
 //
 
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 
 unsigned long long calculatePosition(unsigned long long a, unsigned long long b, unsigned long long C, unsigned long long K){
 	unsigned long long pow = 1;
 	
 	for(int i=0;i<C;i++){
 		pow*=K;
 	}
 	
 	unsigned long long value = (a-1);
 	value *= pow;
 	value += b;
 	return value;
 }
 
 int calculateVector(unsigned long long *positions, unsigned long long currentC, unsigned long long K, int size){
 	unsigned long long positionBuffer;
 	
 	if(size%2){
 		positionBuffer = calculatePosition(positions[0], positions[size-1], currentC, K);
 		size--;
 		for (int i=0; i<size/2; i++) {
 			positions[i] = calculatePosition(positions[i], positions[size-i-1], currentC, K);
 		}
 		positions[size/2] = positionBuffer;
 		return size/2+1;
 	}else{
 		for (int i=0; i<size/2; i++) {
 			positions[i] = calculatePosition(positions[i], positions[size-i-1], currentC, K);
 		}
 		return size/2;
 	}
 	
 }
 
 int main(int argc, const char * argv[]) {
 	
 	FILE* input = fopen("In.in", "r");
 	FILE* output = fopen("Out.out", "w");
 	
 	
 	int cases;
 	
 	fscanf(input, "%d\n",&cases);
 	
 	int currentCase = 1;
 	while (currentCase <= cases) {
 		unsigned long long K, C, S;
 		
 		fscanf(input, "%llu %llu %llu",&K,&C,&S);
 		
 		unsigned long long neededPeople = 1<<(C-1);
 		neededPeople = K/neededPeople;
 		
 		//C will never be 0
 		if(S>=neededPeople){
 			unsigned long long positions[100];
 			int size = (int)K;
 			for(int i=0;i<K;i++){
 				positions[i] = i+1;
 			}
 			
 			for(int i=1; i<C; i++){
 				size = calculateVector(positions, i, K, size);
 			}
 			
 			fprintf(output, "Case #%d:",currentCase);
 			for(int i=0; i<size;i++){
 				fprintf(output, " %llu",positions[i]);
 			}
 			fprintf(output, "\n");
 			
 		}else{
 			fprintf(output, "Case #%d: IMPOSSIBLE\n",currentCase);
 		}
 		
 		currentCase ++;
 	}
 	
 	
 	fclose(input);
 	fclose(output);
 	
 	return 0;
 
 }
