// cat input.in | ./a.out > output
 #include <iostream>
 #include <vector>
 
 
 typedef long long myint;
 
 template <typename T>
 std::vector<T> read_vector(int length, std::istream& in = std::cin) {
 	std::vector<T> vector;
 	for(; length>0; length--) {
 		T item;
 		in >> item;
 		vector.push_back(item);
 	}
 	return vector;
 }
 
 
 
 
 
 
 
 // has to print everything except "Case #n: " and eol \n
 // read from std::cin
 void handle_case() {
 	myint k, c, s;
 	std::cin >> k >> c >> s;
 	if(c * s < k) {
 		std::cout << " IMPOSSIBLE";
 		return;
 	}
 	
 	myint tiles_offset = 0;
 	myint last_tile = 1;
 	for(myint i=0; i< c; i++) {
 		if(i<c-1) {
 			tiles_offset *= k;
 			tiles_offset += 1;
 		}
 		last_tile *= k;
 		if(last_tile < 0)
 			std::cerr << "Overflow!" << std::endl;
 	}
 	
 	myint tiles_per_block = last_tile/k;
 	myint to_check_init;
 	for(to_check_init = 1; s > 0 && to_check_init <= k; s--, to_check_init += c) {
 		std::cout << " " << ((to_check_init-1)*tiles_per_block + tiles_offset+1);
 	}
 	to_check_init -= c;
 	if(s>0 && to_check_init != k) {
 		std::cout << " " << ((k-1)*tiles_per_block + tiles_offset+1);
 	}
 }
 
 
 int main() {
 	int num_cases;
 	std::cin >> num_cases;
 	for(int tcase = 1; tcase <= num_cases; tcase++) {
 		std::cout << "Case #" << tcase << ":";
 		handle_case();
 		std::cout << std::endl;
 	}
 }
