/*
  * Project: Code Jam, Qualification Round 2016
  * Authors: Vendula Poncova, poncovka@gmail.com
  * Date:    9.4.2016
  */
 
 #include <stdio.h>
 #include <stdlib.h>
 
 int main (int argc, char *argv[]) {
 
   int tests = 0;
 
   // get the number of cases
   if (argc > 1 || scanf("%d\n", &tests) != 1) {
     fprintf(stderr, "Error");
     return -1;
   }
 
   // process test cases
   for (int test = 1; test <= tests; test++) {
 
     int K, C, S;
 
     // process line
     if (scanf("%d %d %d\n", &K, &C, &S) != 3) {
       fprintf(stderr, "Error");
       return -1;
     }    
 
     // clean tile 1
     if (K == 1) {
       printf("Case #%d: %d\n", test, 1);
     }
     // clean tiles 1,2,...,K
     else if (C == 1) {
 
       if (S < K) {
         printf("Case #%d: IMPOSSIBLE\n", test);
       }
       else {
         printf("Case #%d:", test);
         
         for (int i = 1; i <= K; i++){
           printf(" %d", i);
         } 
 
         printf("\n");
 
       }
     }
     // clean tiles from groups
     else {
 
       int tiles = (K / 2) + (K % 2);
       
       if (S < tiles) {
         printf("Case #%d: IMPOSSIBLE\n", test);
       }
       else {
 
         printf("Case #%d:", test);
 
         for (int i = 1; i <= K; i += 2) {
 
           int group = i;
           int position = (i + 1 <= K) ? (i + 1) : i; 
           int tile = K * (group - 1) + position;
 
           printf(" %d", tile);
         }
 
         printf("\n");
       }
     }
   }
 
   return 0;
 }
 /* end of file */
