#include <map>
 #include <set>
 #include <cmath>
 #include <queue>
 #include <vector>
 #include <string>
 #include <cstdio>
 #include <cstdlib>
 #include <cstring>
 #include <cassert>
 #include <numeric>
 #include <algorithm>
 #include <iostream>
 #include <fstream>
 #include <sstream>
 #include <ctime>
 #include <limits>
 using namespace std;
 
 // #pragma warning(disable: 4018)
 // #include "../my_header.h"
 
 
 struct solver
 {
 	int max_steps_per_row(int R, int C, int W)
 	{
 		assert(W <= C);
 
 		if (W == C)
 			return W;
 
 		int left = (C - 1) / 2;
 		int right = C - 1 - left;
 
 		int hit_max = W + 1;
 
 		if (left < W && right < W)
 			return hit_max;
 
 		int no_hit_max = 1;
 		if (left >= W)
 			no_hit_max += max_steps_per_row(R, left, W);
 		if (right >= W)
 			no_hit_max += max_steps_per_row(R, right, W);
 
 		return max(hit_max, no_hit_max);
 	}
 
 	int solve(int R, int C, int W)
 	{
 		return max_steps_per_row(R, C, W);
 	}
 };
 
 /*************************************************************************************/
 
 void process_test_case(int case_num, ifstream &ifs, ofstream &ofs)
 {
 	int R, C, W;
 	ifs >> R >> C >> W;
 
 	long long res = solver().solve(R, C, W);
 
 	cout << "Case #" << case_num << ": " << res << endl;
 	ofs << "Case #" << case_num << ": " << res << endl;
 }
 
 /*************************************************************************************/
 
 int main(int argc, char **argv)
 {
 	if (argc != 3) {
 		cout << "Usage: runme <input file> <output file>" << endl;
 		return 1;
 	}
 
 	ifstream ifs(argv[1], ifstream::in);
 	ofstream ofs(argv[2]);
 
 	ofs.precision(7);
 	ofs << fixed;
 
 	int T;
 	ifs >> T;
 	// assert(T > 0 && T < 200);
 
 	for (int i=0 ; i < T ; i++)
 	{
 		// if (i > 0)
 		// 	cout << "\n---------------------------------------------\n\n";
 		process_test_case(i+1, ifs, ofs);
 	}
 
 	return 0;
 }
