// A: Getting the Digits
 
 #include <stdio.h>
 #include <string.h>
 
 char *strings[10] = {"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
 
 void countLetterFreq(int freq[26], char *string) {
     for (int i = 0; i < 26; i++) {
         freq[i] = 0;
     }
     for (char *ch = string; *ch != 0; ch++) {
         freq[*ch - 'A']++;
     }
 }
 
 int countAndDecrement(int freq[26], char *string, char indicator) {
     int count = freq[indicator - 'A'];
     for (char *ch = string; *ch != 0; ch++) {
         freq[*ch - 'A'] -= count;
     }
     return count;
 }
 
 int main() {
     int T;
     scanf("%d", &T);
     for (int cases = 0; cases < T; cases++) {
         char S[2001];
         scanf("%s", S);
 
         int freq[26];
         countLetterFreq(freq, S);
 
         // Now, to count
         int order[10] = {0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
         char indicators[10] = {'Z', 'W', 'U', 'X', 'G', 'O', 'T', 'F', 'S', 'I'};
         int counts[10];
         for (int i = 0; i < 10; i++) {
             int number = order[i];
             counts[number] = countAndDecrement(freq, strings[number], indicators[i]);
         }
 
         printf("Case #%d: ", cases + 1);
         for (char ch = '0'; ch <= '9'; ch++) {
             for (int times = 0; times < counts[ch - '0']; times++) {
                 putchar(ch);
             }
         }
         printf("\n");
     }
     return 0;
 }
