#include <stdio.h>
 #include <math.h>
 
 void solve(long n, long k, FILE *out);
 int closest_square(long k);
 
 int main(int argc, char *argv[]) {
   FILE *in = fopen("C-large.in", "r");
   FILE *out = fopen("bathroom-stalls.out", "w");
 
   int t;
   fscanf(in, "%d", &t);
   for (int i = 1; i <= t; i++) {
     long n, k;
     fscanf(in, "%ld %ld", &n, &k);
     fprintf(out, "Case #%d: ", i);
     solve(n, k, out);
   }
 
   fclose(in);
   fclose(out);
 
   return 0;
 }
 
 void solve(long n, long k, FILE *out) {
   double coef = ((double)n - (double)k) / closest_square(k);
   double d = fmod(coef, 1);
   if (d >= 0.5) {
     long hresult = ceil(coef);
     long lresult = floor(coef);
     fprintf(out, "%ld %ld\n", hresult, lresult);
   } else {
     long result = floor(coef);
     fprintf(out, "%ld %ld\n", result, result);
   }
 }
 
 int closest_square(long k) {
   long sq = 2, lastsq = sq;
   while (k >= sq) {
     sq *= 2;
   }
   return sq;
 }
