#include <iostream>
 #include <map>
 #include <algorithm>
 #include <math.h>
 #include <vector>
 #include <stdint.h>
 using namespace std;
 
 typedef struct p {
   int64_t val;
   struct p *left, *right;
 } node;
 
 bool cmpFunc(node *i, node *j){
   return i->val>j->val;
 }
 
 node *createT(map<int64_t, node*> &tree, int64_t val) {
   if(val <= 0) return NULL;
   map<int64_t, node*>::iterator it = tree.find(val);
   if(it != tree.end()) return it->second;
   node *res = (node *) malloc(sizeof(node));
   res->val = val;
   int64_t L = ceil(val/2.0) - 1;
   int64_t R = val - L - 1;
   res->left = createT(tree, L);
   res->right = createT(tree, R);
   tree[val] = res;
 }
 
 map<int64_t, int64_t> mapDifference(map<int64_t, int64_t> lastLevel, map<int64_t, int64_t> prev) {
   map<int64_t, int64_t> diff;
   for(map<int64_t, int64_t>::iterator it = prev.begin(); it != prev.end(); it++) {
     lastLevel[it->first] -= it->second;
   }
 
   for(map<int64_t, int64_t>::iterator it = lastLevel.begin(); it != lastLevel.end(); it++) {
     if(it->second != 0) {
       diff[it->first] = it->second;
     }
   }
   return diff;
 }
 
 void getLastLevel(map<pair<int, int>, map<int64_t, int64_t> > &savedAns, map<int64_t, int64_t> &lastLevel, node *n, int64_t s) {
   if(n == NULL) return;
   if(savedAns.find(make_pair(n->val, s)) != savedAns.end()) {
     map<int64_t, int64_t> temp = savedAns[make_pair(n->val, s)];
     for(map<int64_t, int64_t>::iterator it = temp.begin(); it != temp.end(); it++) {
       if(lastLevel.find(it->first) == lastLevel.end()) lastLevel[it->first] = 0;
       lastLevel[it->first] += it->second;
     }
     return;
   }
   if(s == 0) {
     if(lastLevel.find(n->val) == lastLevel.end()) lastLevel[n->val] = 0;
     lastLevel[n->val]++;
   } else {
     map<int64_t, int64_t> prev(lastLevel.begin(), lastLevel.end());
     getLastLevel(savedAns, lastLevel, n->left, s-1);
     getLastLevel(savedAns, lastLevel, n->right, s-1);
     map<int64_t, int64_t> diff = mapDifference(lastLevel, prev);
     savedAns[make_pair(n->val, s)] = diff;
   }
 }
 
 int64_t maxKey(map<int64_t, int64_t> &t) {
   int64_t max=-1;
   for(map<int64_t, int64_t>::iterator it = t.begin(); it != t.end(); it++) {
     if(it->first > max) max = it->first;
   }
   return max;
 }
 
 int main() {
 	int64_t t;
 	cin >> t;
   map<int64_t, node*> tree;
   map<pair<int, int>, map<int64_t, int64_t> > savedAns;
   node *res = (node *) malloc(sizeof(node));
   res->val = 1;
   res->left = NULL;
   res->right = NULL;
   tree[1] = res;
   tree[0] = NULL;
 	for(int64_t caseCount = 1; caseCount <= t; caseCount++) {
 	   int64_t n,k,s=0;
 	   cin >> n >> k;
      createT(tree, n);
      while(pow(2,s) - 1 < k) {
        s++;
      }
      s--;
      int64_t noDel = pow(2,s) - 1;
      map<int64_t, int64_t> lastLevel;
      getLastLevel(savedAns, lastLevel, tree[n], s);
      int64_t val=0;
      k -= noDel;
      while(k >= 0) {
        int64_t key = maxKey(lastLevel);
        if(lastLevel[key] >= k) {
          val = key;
          break;
        }
        k-=lastLevel[key];
        lastLevel.erase(lastLevel.find(key));
      }
      int64_t L = ceil(val/2.0) - 1;
      int64_t R = val - L - 1;
 	   cout << "Case #" << caseCount << ": " << max(L,R) << " " << min(L,R) << endl;
 	}
 	return 0;
 }
