#include <iostream>
 #include <cmath>
 
 typedef unsigned long ul;
 using namespace std;
 
 
 template <class T>
 T inverse(T a, T n) {
     // calculate the multiplicative inverse
     // in modular structures
     T t = 1, r = a, q;
     T t_ = 0, r_ = n;
     T t_tmp, r_tmp;
 
     while (r) {
         q = r_/r;
         r_tmp = r_;
         t_tmp = t_;
         t_ = t;
         r_ = r;
         t = t_tmp - q*t;
         r = r_tmp - q*r;
     }
     if (r_ > 1)
         // not invertible
         return 0;
     if (t_ < 0)
         t_ += n;
     return t_;
 }
 
 
 int main() {
   ul t, n, k;
   cin >> t;
 
   for (ul i = 0; i < t; ++i) {
     cin >> n >> k;
 
     ul nearestPow = pow(2, floor(log2(k)));
     ul biggerIslandSize = ceil(double(n - (nearestPow - 1))/nearestPow);
     ul smallerIslandNos = (nearestPow*biggerIslandSize % nearestPow)*
       inverse(biggerIslandSize - 1, biggerIslandSize) % biggerIslandSize;
     ul biggerIslandNos = nearestPow - smallerIslandNos;
 
     ul remaining = k - nearestPow;
     ul Ls, Rs;
     if (remaining <= biggerIslandNos) {
       Ls = (biggerIslandSize + 1)/2 - 1;
       Rs = biggerIslandSize - Ls - 1;
     } else {
       Ls = (biggerIslandSize)/2 - 1;
       Rs = biggerIslandSize - 1 -Ls - 1;
     }
     cout << "Case #" << i + 1 << ": " << max(Ls, Rs) << " " << min(Ls, Rs) << "\n";
   }
 }
