#include <stdlib.h>
 #include <stdio.h>
 
 // instance solver: last two params are output params
 void stalls(unsigned long n, unsigned long k, unsigned long* outMin,
             unsigned long* outMax) {
   // loop until finished:
   int ctN = 1;
   int ctNm1 = 0;
   for(;; n /= 2) {
     // two cases: based on parity of N
     if((n % 2) == 0) {
       // standard case 1: ctN's go to q and qm1 each
       if(k <= ctN) {
         *outMax = n/2;
         *outMin = n/2 - 1;
         return;
       }
       k -= ctN;
       // standard case 2: both ctNm1's go to qm1
       if(k <= ctNm1) {
         *outMax = (n-1)/2;
         *outMin = (n-1)/2;
         return;
       }
       k -= ctNm1;
       ctNm1 = ctN + 2 * ctNm1;
     } else {
       // reverse case 1: both ctN's go to q
       if(k <= ctN) {
         *outMax = n/2;
         *outMin = n/2;
         return;
       }
       k -= ctN;
       // reverse case 2: ctNm1's got to q and qm1, one each
       if(k <= ctNm1) {
         *outMax = (n-1)/2;
         *outMin = (n-1)/2 - 1;
         return;
       }
       k -= ctNm1;
       ctN = 2 * ctN + ctNm1;
     }
   }
 }
 
 // main function
 int main(int argc, char* argv[]) {
   // read in instance count
   int instance_ct = 0;
   scanf("%d ", &instance_ct);
 
   // solve all instances
   for(int i = 1; i <= instance_ct; i++) {
     // read in the parameters
     unsigned long inputN, inputK;
     scanf("%lu %lu ", &inputN, &inputK);
 
     // solve instance
     unsigned long outputMin, outputMax;
     stalls(inputN, inputK, &outputMin, &outputMax);
 
     // print solution
     printf("Case #%d: %lu %lu\n", i, outputMax, outputMin);
   }
 
   // return success
   return 0;
 }
 
