#include <stdio.h>
 #include <stdlib.h>
 #include <stdint.h>
 
 /**
  * biggest min(Ls, Rs): as far as possible from the closest
  * biggest max(Ls, Rs): as far as possible from the farthest
  * biggest ( -i )     : first seat
  *
  * Output: max(Ls, Rs) ; min(Ls, Rs)
  * max(Ls, Rs) >= min(Ls, Rs)
  *
  * if n == k:
  * y = z = 0
  *
  * if k == 1:
  *     y = floor((n - 1) / 2)
  *     z = ceil ((n - 1) / 2)
  *
  *****************************************************************************
  *
  * if n is odd, we can solve two similar problems:
  * o ... - ... - ... - ... o
  * o ... - ... x ... - ... o
  *   ~~~~~~~~~   ~~~~~~~~~
  *   problem 1   problem 2
  *
  * o - - - - - - - - - - - - - - - o (15)                      0
  * o - - - - - - - x - - - - - - - o (7, 7)                    1 (7, 7)
  * o - - - x - - - o - - - x - - - o (3, 3, 3, 3)              3 (3, 3)
  * o - x - o - x - o - x - o - x - o (1, 1, 1, 1, 1, 1, 1, 1)  7 (1, 1)
  *
  * f(15, 1)     = (7, 7)
  * f(15, 2..3)  = (3, 3)
  * f(15, 4..7)  = (1, 1)
  * f(15, 7..15) = (0, 0)
  *
  *****************************************************************************
  *
  * if n is even, it gets complicated:
  * o - - - - - - - - - - - - - - - - o (16)                  0         0
  * o - - - - - - - x - - - - - - - - o (7, 8)                1 (8, 7)  1
  *
  * o - - - - - - - o - - - x - - - - o (7, 3, 4)             2 (4, 3)  10
  * o - - - x - - - o - - - o - - - - o (3, 3, 3, 4)          3 (3, 3)  11
  *
  * o - - - o - - - o - - - o - x - - o (3, 3, 3, 1, 2)       4 (2, 1)  100
  * o - x - o - - - o - - - o - o - - o (1, 1, 3, 3, 1, 2)    5 (1, 1)  101
  * o - o - o - x - o - - - o - o - - o (1, 1, 1, 1, 3, 1, 2) 6 (1, 1)  110
  * o - o - o - o - o - x - o - o - - o ...                   7 (1, 1)  111
  *
  * o - o - o - o - o - o - o - o x - o ...                   8 (1, 0)
  * o x o - o - o - o - o - o - o o - o ...                   9 (0, 0)
  * ...
  *
  * f(16, 1)     = (8, 7)
  * f(16, 2)     = (4, 3)
  * f(16, 3)     = (3, 3)
  * f(16, 8)     = (1, 0)
  * f(16, 9..16) = (0, 0)
  */
 void solve(uint64_t n, uint64_t k, uint64_t *y, uint64_t *z)
 {
 	/* This block seems superfluous... */
 	if(n == k) {
 		*y = 0;
 		*z = 0;
 		return;
 	}
 
 	if(k == 1) {
 		*z = (n - 1) / 2;
 		*y = (n - 1) - *z;
 		return;
 	}
 
 	if(n & 1)
 		return solve(n / 2, k / 2, y, z);
 
 	if(k & 1)
 		return solve(n / 2 - 1, k / 2, y, z);
 	else
 		return solve(n / 2, k / 2, y, z);
 }
 
 int main(int argc, char *argv[])
 {
 	size_t   i, m;
 	uint64_t k, n;
 	uint64_t y, z;
 
 	scanf("%u", &m);
 
 	for(i = 0; i < m; i++) {
 		scanf("%llu %llu", &n, &k);
 		printf("Case #%d: ", i + 1);
 		solve(n, k, &y, &z);
 		printf("%llu %llu\n", y, z);
 	}
 
 	return EXIT_SUCCESS;
 }