
 #include <cstdio>
 #include <cstdlib>
 #include <vector>
 #include <queue>
 #include <algorithm>
 #include <cstring>
 #include <iostream>
 #include <string>
 #include <sstream>
 #include <fstream>
 #include <utility>
 #include <map>
 
 using namespace std;
 
 typedef struct Interval {
     int l;
     int r;
     int size;
 } Interval;
 
 class MyComp {
 public:
     bool operator() (Interval& l, Interval r) {
         if (l.size < r.size) {
             return true;
         } else if (l.size == r.size) {
             if (l.l < r.l) {
                 return true;
             }
         } else {
             return false;
         }
     }
 };
 
 pair<int, int> solve(int n, int k) {
     MyComp comp;
     priority_queue<Interval, vector<Interval>, MyComp> pq(comp);
 
     vector<int> stalls(n+2);
     stalls[0] = 1;
     stalls[n+1] = 1;
 
     Interval it;
     it.l = 1;
     it.r = n;
     it.size = n;
     pq.push(it);
 
     for (int i = 0; i < k; i++) {
         Interval it = pq.top();
         pq.pop();
         int pos = (it.r + it.l) / 2;
         stalls[pos] = 1;
         if (it.size == 1) {
             if (i == k-1) {
                 int l = pos - it.l;
                 int r = it.r - pos;
 
                 return make_pair(max(l, r), min(l, r));
             }
             continue;
         } else if (it.size == 2) {
             Interval itNew;
             itNew.l = it.r;
             itNew.r = it.r;
             itNew.size = 1;
             pq.push(itNew);
         } else {
             Interval itNew;
             itNew.l = it.l;
             itNew.r = pos-1;
             itNew.size = (pos-1) - it.l + 1;
             pq.push(itNew);
 
             Interval itNewTwo;
             itNewTwo.l = pos+1;
             itNewTwo.r = it.r;
             itNewTwo.size = itNewTwo.r - itNewTwo.l + 1;
             pq.push(itNewTwo);
         }
 
         if (i == k-1) {
             int l = pos - it.l;
             int r = it.r - pos;
             return make_pair(max(l, r), min(l, r));
         }
     }
 
 };
 
 pair<long long, long long> solve_smart(long long n, long long k) {
     map<long long, long long>  m;
     vector<pair<long long, long long> > v;
     m[n] = 1;
     long long i = 1;
     long long oldi = i;
     while (i < k) {
         // cout << "i is " << i << endl;
         oldi = i;
         i = i + i*2;
 
         v.clear();
         
         for (auto it : m) {
             // cout << "I am seeing <" << it.first << ", " << it.second << ">" << endl;
             v.push_back(make_pair(it.first, it.second));
         }
         m.clear();
         // cout << "---------------" << endl;
 
         long long mid;
         long long mid2;
         for (auto it : v) {
 
             long long me = it.first;
             mid = (me - 1) / 2;
             mid2 = (me - 1) - mid;
 
             if (mid > 0) {
                 m[mid] += it.second;
             }
 
             if (mid2 > 0) m[mid2] += it.second;
         }
 
         if (i >= k) {
             i = oldi;
             break;
         }
 
         for (auto it : m) {
             // cout << "I am seeing afterwards.. <" << it.first << ", " << it.second << ">" << endl;
         }
     }
 
     long long left = k - i;
     // cout << "broke the loop..left = " << left << endl;
     if (m.size() == 0) {
         return make_pair(0, 0);
     } else if (m.size() > 1) {
 
         v.clear();
 
         for (auto it: m) {
             v.push_back(make_pair(it.first, it.second));
         }
 
         pair<long long, long long> small = v[0];
         pair<long long, long long> big = v[1];
 
         
 
         if (small.first > big.first) {
             small = v[1];
             big = v[0];
         }
 
         // cout << small.first << " " << small.second << endl;
         // cout << big.first << " " << big.second << endl;
 
         if (left <= big.second) {
 
             long long me = big.first;
             long long mid = (me - 1) / 2;
             long long mid2 = (me - 1) - mid;
 
             return make_pair(max(mid, mid2), min(mid, mid2));
         } else {
             long long me = small.first;
             long long mid = (me - 1) / 2;
             long long mid2 = (me - 1) - mid;
 
             return make_pair(max(mid, mid2), min(mid, mid2));
         }
     } else {
 
         pair<long long, long long> small = *(m.begin());
         // cout << small.first << " " << small.second << endl;
         long long me = small.first;
         long long mid = (me - 1) / 2;
         long long mid2 = (me - 1) - mid;
 
         return make_pair(max(mid, mid2), min(mid, mid2));
     }
 };
 
 
 int main() {
 
     int t;
     int n, k;
 
     scanf("%d", &t);
     // pair<int, int> ans = solve_smart(3, 1);
     // cout << "--------" << endl;
     // cout << ans.first << " " << ans.second << endl;   
 
     // for (int i = 1; i <= 10; i++) {
     //     for (int j = 1; j <= i; j++) {
     //         pair<int, int> ans = solve_smart(i, j);
     //         pair<int, int> ans2 = solve(i, j);
     //         if (ans != ans2) {
     //             cout << "for i: " << i << " and j: " << j << " smart has: "<< ans.first << " " << ans.second << endl;   
     //             cout << "for i: " << i << " and j: " << j << " dumb has: " << ans2.first << " " << ans2.second << endl;   
     //         }
     //     }
     for (int i = 1; i <= t; i++) {
         scanf("%d %d", &n, &k);
         // solve_smart(n, k);
        pair<int, int> ans = solve_smart(n, k);
        cout << "Case #" << i << ": " << ans.first << " " << ans.second << endl;
     }
 }
