#include <iostream>
 #include <cstdlib>
 #include <vector>
 
 typedef unsigned long long ull;
 
 void solve(ull *x, ull *y, ull n, ull k)
 {
 	ull tmp = k;
 	ull elements_above = 1;
 	unsigned int row = 0;
 
 	// compute the row in an binary tree 
 	while(tmp)
 	{
 		tmp >>= 0x1;
 		++row;
 	}
 
 	// make 0 based
 	--row;
 
 	// compute number elements above that row
 	elements_above = 0x1 << row;
 	--elements_above;
 
 	// compute elements in row
 	ull theo_elements_in_row = 0x1 << row;
 	ull remaining_elements = n - elements_above;
 
 	// compute the largest block in the row
 	ull largest_block = n >> row;
 	
 	// compute number of larger blocks
 	ull f = remaining_elements - (largest_block - 1) * theo_elements_in_row;
 
 	// compute the position in the row (0 based)
 	ull num_in_row = k - elements_above - 1;
 	ull block_size = (f > num_in_row) ? largest_block : largest_block - 1;
 	
 
 	*x = (block_size - 1) >> 0x1;
 	*y = (block_size - 1) - *x;
 }
 
 int main(int argc, char **argv)
 {
 	ull x, y;
 	ull k, n; 
 	int t, i;
 
 	std::cin >> t;
 	for(i = 1; i <= t; ++i)
 	{
 		std::cin >> n >> k;
 		solve(&x, &y, n, k);
 		std::cout << "Case #" << i << ": " << std::max(x, y) << " " << std::min(x, y) << std::endl;
 	}
 	return 0;
 }
