#include <stdio.h>
 #include <stdlib.h>
 #include <math.h>
 #include <string.h>
 
 int max_size;
 int *nodes;
 int item_nums;
 
 void check (void *memory, char *message)
 {
   if (memory == NULL)
   {
     fprintf (stderr, "Can't allocate memory for %s\n", message);
     exit (3);
   }
 }
 
 int initialise_data_structures(int size) {
   max_size = size;
   item_nums = 0;
   nodes = (int*) calloc(size, sizeof(int));
   check(nodes, "priority queue for searching");
   return 0;
 }
 
 int parent(int i) { return (i-1)/2; }
 int left_child(int i) { return 2*i+1; }
 int right_child(int i) { return 2*i+2; }
 
 int upheap(int index) {
   if (index <= 0)
     return index;
   if (nodes[index] > nodes[parent(index)]) {
     int child = nodes[index];
     nodes[index] = nodes[parent(index)];
     nodes[parent(index)] = child;
     return upheap(parent(index));
   }
   else
     return index;
 }
 
 int downheap(int index) {
   if (index >= item_nums || left_child(index) >= item_nums)
     return index;
   if (right_child(index) < item_nums) {
     if (nodes[index] < nodes[left_child(index)]
         && nodes[index] >= nodes[right_child(index)]) {
       int parent = nodes[index];
       nodes[index] = nodes[left_child(index)];
       nodes[left_child(index)] = parent;
       return downheap(left_child(index));
     }
     else if (nodes[index] >= nodes[left_child(index)]
              && nodes[index] < nodes[right_child(index)]) {
       int parent = nodes[index];
       nodes[index] = nodes[right_child(index)];
       nodes[right_child(index)] = parent;
       return downheap(right_child(index));
     }
     else if (nodes[index] < nodes[left_child(index)]
              && nodes[index] < nodes[right_child(index)]) {
       int parent = nodes[index];
       int child_index = (nodes[left_child(index)] > nodes[right_child(index)])?
                         left_child(index) : right_child(index);
       nodes[index] = nodes[child_index];
       nodes[child_index] = parent;
       return downheap(child_index);
     }
   }
   else if (nodes[index] > nodes[left_child(index)]) {
     int parent = nodes[index];
     nodes[index] = nodes[left_child(index)];
     nodes[left_child(index)] = parent;
     return downheap(left_child(index));
   }
   return index;
 }
 
 int empty() {
   return !item_nums;
 }
 
 int top() {
   if (empty()) {
     fprintf(stderr, "!!!There is no node in the data structure when topping\n");
     exit(1);
   }
   return nodes[0];
 }
 
 int pop() {
   if (empty()) {
     fprintf(stderr, "!!!There is no node in the data structure when poping\n");
     exit(1);
   }
   item_nums--;
   int toReturn = nodes[0];
   nodes[0] = nodes[item_nums];
   nodes[item_nums] = 0;
   downheap(0);
   return toReturn;
 }
 
 int push(int node) {
   if (item_nums == max_size) {
     fprintf(stderr, "!!!The data structure is fulled and cannot hold more nodes\n");
     exit(2);
   }
   item_nums++;
   nodes[item_nums-1] = node;
   upheap(item_nums-1);
   return 0;
 }
 
 int main(int argc, char const *argv[])
 {
   // A stream for getting data from the user.
   FILE *in = fopen(argv[1], "r");
   if (!in) { fprintf(stderr, "Can't open %s for reading\n", argv[1]); exit(-1); }
   FILE *out = fopen("output","w");
   if (!out) { fprintf(stderr, "Can't open output for writing\n"); exit(-2); }
   int num_cases;
   fscanf(in, "%d\n", &num_cases);
 
   for (int i = 1; i <= num_cases; ++i)
   {
     int n, k;
     fscanf(in, "%d %d\n", &n, &k);
 
     initialise_data_structures(n+1);
     for (int j = 1; j < k; ++j)
     {
       push(n/2);
       push((n-1)/2);
       n = pop();
     }
 
     fprintf(out, "Case #%d: %d %d\n", i, n/2, (n-1)/2);
   }
 
   fclose(in);
   fclose(out);
 
   return 0;
 }
