#include <stdio.h>
 
 #define SIZE 35
 
 struct Stall {
     unsigned long long int s;
     unsigned long long int left;
     unsigned long long int right;
 };
 
 unsigned long long int insertInDescendingOrder(struct Stall* n,
                                      unsigned long long int size,
                                      unsigned long long int value) {
     unsigned long long int j, k;
     struct Stall aux, cur;
 
     cur.left = cur.right = 0;
     cur.s = value;
 
     for (j = 0; j < size; j++) {
         if (n[j].s == 0 /*&& n[j].left == 0 && n[j].right == 0*/) {
             n[j] = cur;
             break;
 
         } else if (n[j].s < cur.s) {
             aux = n[j];
             n[j] = cur;
             cur = aux;
         }
     }
 
     return value;
 }
 
 //  Problem from: https://code.google.com/codejam/contest/3264486/dashboard#s=p2
 int main(int argc, char *argv[]) {
     int times;    // number of test cases
     scanf("%d", &times);
 
     for (int i = 0; i < times; i++) {
         unsigned long long int input;
         unsigned long long int k;
         scanf("%llu", &input);
         scanf("%llu", &k);
 
         struct Stall n[k];
         unsigned long long int j;
         for (j = 0; j < k; j++) {
             n[j].s = n[j].left = n[j].right = 0;
         }
 
         n[0].s = input;
 
         for (j = 0; j < k; j++) {
             n[j].left = insertInDescendingOrder(n, k, n[j].s / 2);
             n[j].right = insertInDescendingOrder(n, k, (n[j].s % 2)
                                              ? n[j].s / 2
                                              : n[j].s / 2 - 1);
         }
 
 //        for (j = 0; j < k; j++) {
 //            printf("## %llu >> %llu :: %llu | %llu\n", j, n[j].s, n[j].left, n[j].right);
 //        }
 
         printf("Case #%d: %llu %llu\n", i + 1, n[k - 1].left, n[k - 1].right);
     }
 
     return 0;
 }
