#include <iostream>
 #include <string>
 #include <vector>
 #include <iterator>
 #include <algorithm>
 using namespace std;
 
 typedef unsigned long long ull;
 
 struct Stall {
   char type = '.';
   ull index = 0;
   ull ls;
   ull rs;
 };
 
 pair<ull, ull> choose_stall(ull n, ull k) {
   vector<Stall> bathroom(n + 2);
   
   // guards
   bathroom[0].type = 'O';
   bathroom[0].index = 0;
   bathroom[n + 1].type = 'O';
   bathroom[n + 1].index = n + 1;
   
   // init indexes
   for (ull i = 0; i < bathroom.size(); ++i) {
     bathroom[i].index = i;
   }
   
   ull position;
   
   while (k > 0) {
     for (ull i = 0; i < bathroom.size(); ++i) {
       bathroom[i].ls = 0;
       bathroom[i].rs = 0;
     }
     
     for (ull i = 1; i < bathroom.size() - 1; ++i) {
       if (bathroom[i].type == '.') {
         // calculate ls
         for (ull j = i - 1; j > 0; --j) {
           if (bathroom[j].type == '.') {
             ++bathroom[i].ls;
           } else {
             break;
           }
         }
         
         // calculate rs
         for (ull j = i + 1; j < bathroom.size(); ++j) {
           if (bathroom[j].type == '.') {
             ++bathroom[i].rs;
           } else {
             break;
           }
         }
       }
     }
     
     // find min(Ls, Rs) for each empty stall
     vector<ull> mins(n + 2);
     for (ull j = 0; j < bathroom.size(); ++j) {
       if (bathroom[j].type == '.') {
         mins[j] = min(bathroom[j].ls, bathroom[j].rs);
       } else {
         mins[j] = 0;
       }
     }
     
     // calculate max of min(Ls, Rs)
     ull maximum = *max_element(begin(mins), end(mins));
     
     // set of max(min(Ls, Rs)) stalls
     vector<Stall> s;
     for (ull j = 0; j < bathroom.size(); ++j) {
       if (min(bathroom[j].ls, bathroom[j].rs) == maximum) {
         s.push_back(bathroom[j]);
       }
     }
     
     if (s.size() == 1) {
       position = s[0].index;
       bathroom[position].type = 'O';
       --k;
       continue;
     }
     
     // find max(Ls, Rs) for each stall in s
     vector<ull> maxs;
     for (ull j = 0; j < s.size(); ++j) {
       ull tmp = max(s[j].ls, s[j].rs);
       maxs.push_back(tmp);
     }
     
     // calculate max of max(Ls, Rs)
     maximum = *max_element(begin(maxs), end(maxs));
     
     // set of max(max(Ls, Rs)) stalls
     vector<Stall> s2;
     for (ull j = 0; j < bathroom.size(); ++j) {
       if (max(bathroom[j].ls, bathroom[j].rs) == maximum) {
         s2.push_back(bathroom[j]);
       }
     }
     
     // occupy left most stall
     position = s2[0].index;
     bathroom[position].type = 'O';
     
     --k;
   }
   
   Stall last = bathroom[position];
   return {max(last.ls, last.rs), min(last.ls, last.rs)};
 }
 
 int main() {
   int t;
   cin >> t;
   
   for (int i = 1; i <= t; ++i) {
     ull n, k;
     cin >> n >> k;
     cout << "Case #" << i << ": ";
     
     pair<ull, ull> answer = choose_stall(n, k);
     cout << answer.first << " " << answer.second << "\n";
   }
 
   return 0;
 }
