#include<iostream>
 #include<queue>
 #include<vector>
 using namespace std;
 
 class stall{
     public:
         int pos;
         int Ls;
         int Rs;
         int getMax(){
             return max(Ls,Rs);
         }
         int getMin(){
             return min(Ls,Rs);
         }
 };
 class compare{
       public:
           bool operator() (stall s1,stall s2){
               if(s1.getMin()==s2.getMin() && s1.getMax()==s2.getMax())      // case where its an absolute tie
                     return s1.pos>s2.pos;
               else if(s1.getMin()==s2.getMin() && s1.getMax()!=s2.getMax()) // case 2
                     return s1.getMax()<s2.getMax();
               else
                     return s1.getMin()>s2.getMin();              
           }
 };
  
 
 void calculate(const vector<int> &stalls, vector<stall> &distances,priority_queue<stall,vector<stall>, compare> &freestalls){    // calculate the distances
    int last=0;
    int next=stalls.size();
    int pos=0;
    while(true){
    last=pos;
    if(last>stalls.size()-1)
        return;
    while(last!=stalls.size()-1 && stalls[last++]);   // move to the first available stall
    if(last==stalls.size()-1 && stalls[last]==1)       // all possible distances calulated already
         return;
    else if(last==stalls.size()-1 && stalls[last]==0){
         distances[last].Ls = 0;
         distances[last].Rs = 0;
         stall temp;
         temp.pos = last;
         temp.Ls = distances[last].Ls;
         temp.Rs = distances[last].Rs;
         freestalls.push(temp);
         return;
    }
    else
        last--;
    next = stalls.size()-1;
    for(int i=last;i<stalls.size();i++){
         if(stalls[i]){
             next = i;
             break;
         }
    }
    int l=0;
    int r=next-last;
    for(pos = last;pos < next; pos++){   
         distances[pos].Ls = l++;
         distances[pos].Rs = r--;
         stall temp;
         temp.pos = pos;
         temp.Ls = distances[last].Ls;
         temp.Rs = distances[last].Rs;
         freestalls.push(temp);
    }
    }
 }
 
 void fillStalls(int n, int k, int T, priority_queue<stall,vector<stall>, compare> &freestalls){
     vector<int> stalls(n,0);    // the stalls that are unoccupied '0'
     vector<stall> distances(n);
     int Y,Z;
     for(int i=0;i<k;i++){       // 'k' insertions to the stall
         calculate(stalls,distances,freestalls);
         stall selected = freestalls.top();
         int pos = selected.pos;
         freestalls.pop();
         Y = distances[pos].getMax();
         Z = distances[pos].getMin();
     }
     cout<<"Case #"<<T<<": "<<Y<<" "<<Z<<endl;
 }
 
 int main(){
     int T;
     cin>>T;
     for(int i=0;i<T;i++){
         priority_queue<stall,vector<stall>, compare> freestalls;
         int n,k;
         cin>>n>>k;
         fillStalls(n,k,i+1,freestalls);
     }
     return 0;
 }
