#include <iostream>
 #include <cassert>
 #include <vector>
 #include <algorithm>
 #include <cmath>
 
 std::vector<int> decompose(std::int64_t num, int base)
 {
     std::vector<int> v;
     v.reserve(std::log(num)/std::log(base)+1);
     while(num > 0)
     {
         v.push_back(num%base);
         num /= base;
     }
     std::reverse(v.begin(), v.end());
     return v;
 }
 
 std::pair<int, int> stalls(std::int64_t num_stalls, std::int64_t num_people)
 {
     std::vector<int> decisions = decompose(num_people, 2);
     for (int i = 1; i < (int)decisions.size(); ++i)
     {
         num_stalls = (decisions[i] == 0) ? num_stalls/2 : (num_stalls-1)/2;
     }
     return {(num_stalls-1)/2, num_stalls/2};
 }
 
 int main()
 {
     int test_cases = 0;
     std::cin >> test_cases;
 
     for (int i = 1; i <= test_cases; ++i)
     {
         std::int64_t num_stalls = 0;
         std::cin >> num_stalls;
 
         std::int64_t num_people = 0;
         std::cin >> num_people;
 
         auto pair = stalls(num_stalls, num_people);
         std::cout << "Case #" << i << ": " << pair.second << ' ' << pair.first << '\n';
     }
 }
