#include <stdio.h>
 
 typedef struct{
     int addr;
     int min;
     int max;
 }Pair;
 
 
 void calculate_distance(int* stalls, int i, long long int n, int* min, int* max){
     int j = i - 1;
 
     while(j >= 0 && !stalls[j]){
         j--;
     }
 
     j =(i - j) -1;
     int k = i + 1;
 
     while(k < n && !stalls[k]){
         k++;
     }
 
     k = k - i - 1;
 
     if(j < k){
         *min = j;
         *max = k;
     }
 
     else{
         *min = k;
         *max = j;
     }
 }
 
 int select_stall(int* stalls, long long int n){
     Pair best;
     best.addr = -1;
     best.min = -1;
     best.max = -1;
 
     for(int i = 0; i < n; i++){
         if(stalls[i])
             continue;
 
         int min, max;
         calculate_distance(stalls, i, n, &min, &max);
 
         if(min > best.min){
             best.min = min;
             best.max = max;
             best.addr = i;
         }
 
         else if(min == best.min){
             if(max > best.max){
                 best.min = min;
                 best.max = max;
                 best.addr = i;
             }
         }
     }
 
     return best.addr;
 }
 
 
 int main(){
     int stalls[1000000];
     int T;
     scanf("%d", &T);
 
     for(int i = 1; i <= T; i++){
         long long int k, n;
         scanf("%lld %lld", &n, &k);
 
         for(int i = 0; i < n; i++)
             stalls[i] = 0;
 
         int next_addr;
 
         for(int i = 0; i < k; i++){
             next_addr = select_stall(stalls, n);
             stalls[next_addr] = 1;
             
         }
 
         int min, max;
         calculate_distance(stalls, next_addr, n, &min, &max);
 
         printf("Case #%d: %d %d\n", i, max, min);
     }
 
     return 0;
 }
