#include <stdio.h>
 #include <stdbool.h>
 #include <math.h>
 #include <string.h>
 
 #define MAXNUMBERVALUE 1000000000000000000
 #define MAXTESTCASES 100
 
 int min(int a, int b) {
    if (a < b)
       return a;
    return b;
 }
 
 int max(int a, int b) {
    if (a > b)
       return a;
    return b;
 }
 
 int main(void) {
    int inpNum = 0;
    int numTestCases = 0;
 
    // Get the number of test cases
    scanf("%i", &inpNum);
    numTestCases = inpNum;
    if (numTestCases < 1) {
       printf("ERROR: less than 1 test case specified\n");
       return -1;
    }
    else if (numTestCases > MAXTESTCASES) {
       printf("ERROR: more than %i test cases specified\n", MAXTESTCASES);
       return -2;
    }
 
    int numStalls = 0;
    int numPeople = 0;
    for (int i = 0; i < numTestCases; i++) {
       // Get number of stalls (less the 2 guards)
       scanf("%i", &numStalls);
       numStalls = numStalls + 2;
       // Get number of people that need to enter still
       scanf("%i", &numPeople);
 
       printf("Case #%i: ", i+1);
 
       bool stallOccu[numStalls];
       stallOccu[0] = true;
       stallOccu[numStalls-1] = true;
       for (int j = 1; j < numStalls-1; j++) {
          stallOccu[j] = false;
       }
       int minSpace = 0;
       int maxSpace = 0;
       int selected = 0;
       int realMax = 0;
       int stallRankMin[numStalls];
       int stallRankMax[numStalls];
       while (numPeople > 0) {
          minSpace = 0;
          maxSpace = 0; 
          selected = 0;
          realMax = 0;
          for (int j = 0; j < numStalls; j++) {
             stallRankMin[j] = -1;
             stallRankMax[j] = -1;
             if (stallOccu[j])
                continue; // Stall occupied -- next!
             // Figure out how many spaces there are to the left of stall j
             int leftSpace = 0;
             for (int k = j-1; k >= 1; k--) {
                if (stallOccu[k])
                   break;
                leftSpace++;
             }
             // Figure out how many spaces there are to the right of stall j
             int rightSpace = 0;
             for (int k = j+1; k < numStalls-1; k++) {
                if (stallOccu[k])
                   break;
                rightSpace++;
             }
 //printf("j: %i  left: %i  right: %i\n", j, leftSpace, rightSpace);
             int curMaxSpace = max(leftSpace, rightSpace);
             if (curMaxSpace > maxSpace) {
                maxSpace = curMaxSpace;
             }
            
             int curMinSpace = min(leftSpace, rightSpace);
             if (curMinSpace > minSpace) {
                minSpace = curMinSpace;
             }
             stallRankMax[j] = curMaxSpace; 
             stallRankMin[j] = curMinSpace; 
          }
         
          selected = 0;
          realMax = 0;
          for (int j = 0; j < numStalls; j++) {
             if (stallOccu[j])
                continue; // Stall occupied -- next!
 	    if (stallRankMin[j] == minSpace) {
 	       if (realMax == 0 || stallRankMax[j] > realMax) {
                   realMax = stallRankMax[j];
                   selected = j;
                }
             }
          } 
 
          // Go into the stall
          stallOccu[selected] = true;
          numPeople = numPeople - 1;
       } 
       printf("%i %i\n", realMax, minSpace);
 /*
       printf("Stall status: ");
       for (int j = 0; j < numStalls; j++) {
          if (stallOccu[j])
             printf("X");
          else 
             printf("."); 
       }
       printf("\n");
 */
    }
    return 0;
 }
