#include <iostream>
 #include <utility>
 #include <fstream>
 using ull = unsigned long long;
 using ullp = std::pair<ull, ull>;
 
 ullp seat(ull n, ull k)
 {
 	if (k == 1)
 	{
 		ull y = n / 2;
 		ull z = n - y - 1;
 		return ullp(y, z);
 	}
 
 	auto yz = seat(n, static_cast<ull>(k / 2));
 	if (k % 2 == 0) // even 
 	{
 		n = yz.first;
 	}
 	else // odd
 	{
 		n = yz.second;
 	}
 	ull y, z;
 	if (!n)
 	{
 		y = 0, z = 0;
 	}
 	else
 	{
 		y = n / 2;
 		z = n - y - 1;
 	}
 	return ullp(y, z);
 }
 
 int main(int argc, char const *argv[])
 {
 	if (argc < 3)
 	{
 		std::cerr << "Syntax: <program> <in> <out>\n";
 		return -1;
 	}
 	std::ifstream ifs(argv[1]);
 	std::ofstream ofs(argv[2]);
 	int t;
 	ifs >> t;
 	for (int x = 1; x <= t; ++x)
 	{
 		ull n,k;
 		ifs >> n >> k;
 		auto yz = seat(n, k);
 		ofs << "Case #" << x << ": " << yz.first << ' ' << yz.second << '\n';
 	}
 }