#include <stdio.h>
 #include <math.h>
 
 #define RICHARD 0
 #define GABRIEL 1
 
 int solve()
 {
   int X, r, c;
   scanf("%d %d %d\n", &X, &r, &c);
 
   const int R = r > c ? r : c; // Larger
   const int C = r < c ? r : c; // Smaller
 
   if (X == 1) {
     return GABRIEL;
   }
 
   if (X > R && X > C) {
     // Long brick is too big
     return RICHARD;
   }
   if (X / 2 + 1 > C) {
     // Big L does not fit
     return RICHARD;
   }
 
   if (X >= 7) {
     // Can make a hole in the middle
     return RICHARD;
   }
   if ((R * C) % X != 0) {
     // Different number of tiles
     return RICHARD;
   }
 
   return GABRIEL;
 }
 
 int main(int argc, char* argv[])
 {
   int T;
   scanf("%d", &T);
 
   for (int i = 1; i <= T; i++) {
     printf("Case #%d: %s\n", i, solve() ? "GABRIEL" : "RICHARD");
   }
 }
