#include <iostream>
 #include <fstream>
 #include <vector>
 #include <cmath>
 
 using namespace std;
 
 class Solution {
 public:
     string solve(int x, int row, int col) {
         string ans;
         if (row * col % x != 0)
             return string("RICHARD");
         for (int i = 1; i <= sqrt(x); ++i) {
             if (x % i == 0) {
                 if (min(i, x / i) > min(row, col))
                     return string("RICHARD");
             }
         }
         
         vector<vector<int> > grid(row, vector<int>(col, 0));
         
         if (GWin(grid, row * col, x, x, 0, 0))
             return string("GABRIEL");
         else
             return string("RICHARD");
     }
     
     bool GWin(vector<vector<int> >& grid, int rest_num, int total_m, int mark, int x, int y) {
         if (rest_num == 0)
             return true;
         int row = grid.size(), col = grid[0].size(), i;
         for (i = 0; i < 4; ++i) {
             int xx = x + dx[i];
             int yy = y + dy[i];
             if (0 <= xx && xx < row && 0 <= yy && yy < col && grid[xx][yy] == 0) {
                 grid[xx][yy] = 1;
                 if (mark == 1) {
                     if (!GWin(grid, rest_num - 1, total_m, total_m, xx, yy)) {
                         return false;
                     }
                 }
                 else {
                     if (!GWin(grid, rest_num - 1, total_m, mark - 1, xx, yy)) {
                         return false;
                     }
                 }
                 grid[xx][yy] = 0;
             }
         }
         return true;
     }
     
 private:
     int dx[4] = {0, -1, 0, 1};
     int dy[4] = {1, 0, -1, 0};
 };
 
 int main() {
     int case_num;
     string ans;
     Solution s;
     ifstream input("/Users/qianqianzhong/Documents/gcj2015/gcj/D-small-attempt0.in");
     ofstream output("/Users/qianqianzhong/Documents/gcj2015/gcj/output.txt");
     input >> case_num;
     for (int i = 0; i < case_num; ++i) {
         int x, row, col;
         input >> x >> row >> col;
         ans = s.solve(x, row, col);
         output << "Case #" << i + 1 << ": " << ans;
         if (i != case_num - 1)
             output << endl;
     }
     input.close();
     output.close();
     return 0;
 }
