#include <iostream>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <vector>
 #include <map>
 #include <set>
 #include <list>
 using namespace std;
 
 int T;
 
 #define RICHARD 1
 #define GABRIEL 2
 
 struct my {
     char a[5][5];
     int off;
     my() {
         for (int i = 0; i != 5; ++i) {
             for (int j = 0; j != 5; ++j) {
                 a[i][j] = '.';
             }
         }
     }
     my sh() const {
         my res = *this;
         while (res.a[0][0] == '.' && res.a[0][1] == '.' && res.a[0][2] == '.' && res.a[0][3] == '.' && res.a[0][4] == '.') {
             for (int i = 0; i < 4; ++i) {
                 res.a[i][0] = res.a[i + 1][0];
                 res.a[i][1] = res.a[i + 1][1];
                 res.a[i][2] = res.a[i + 1][2];
                 res.a[i][3] = res.a[i + 1][3];
                 res.a[i][4] = res.a[i + 1][4];
             }
             res.a[4][0] = '.';
             res.a[4][1] = '.';
             res.a[4][2] = '.';
             res.a[4][3] = '.';
             res.a[4][4] = '.';
         }
         while (res.a[0][0] == '.' && res.a[1][0] == '.' && res.a[2][0] == '.' && res.a[3][0] == '.' && res.a[4][0] == '.') {
             for (int i = 0; i < 4; ++i) {
                 res.a[0][i] = res.a[0][i + 1];
                 res.a[1][i] = res.a[1][i + 1];
                 res.a[2][i] = res.a[2][i + 1];
                 res.a[3][i] = res.a[3][i + 1];
                 res.a[4][i] = res.a[4][i + 1];
             }
             res.a[0][4] = '.';
             res.a[1][4] = '.';
             res.a[2][4] = '.';
             res.a[3][4] = '.';
             res.a[4][4] = '.';
         }
         res.off = 0;
         while (res.a[res.off][0] == '.') res.off++;
         return res;
     }
     bool copyTo(char v[20][20], int x, int X, int y, int Y) const {
         for (int i = 0; i != 5; i++) {
             for (int j = 0; j != 5; j++) {
                 if (a[i][j] == 'X') {
                     if (x + i >= X || y + j >= Y ||
                             v[x + i][y + j] == 'X') return false;
                 }
             }
         }
         for (int i = 0; i != 5; i++) {
             for (int j = 0; j != 5; j++) {
                 if (a[i][j] == 'X') {
                     v[x + i][y + j] = 'X';
                 }
             }
         }
         return true;
     }
     void clearFrom(char v[20][20], int x, int y) const {
         for (int i = 0; i != 5; i++) {
             for (int j = 0; j != 5; j++) {
                 if (a[i][j] == 'X') {
                     v[x + i][y + j] = '.';
                 }
             }
         }
     }
 };
 
 bool operator<(const my& x, const my& y) {
     int res = memcmp(x.a, y.a, sizeof(char[5][5]));
     return res < 0;
 }
 
 map<int, set<my> > figs;
 
 void init() {
     my o;
     o.a[2][2] = 'X';
     figs[1].insert(o.sh());
     set<my> small; small.insert(o);
     set<my> big;
     int size = 2;
     for (int size = 2; size <= 5; ++size) {
         for (set<my>::iterator it = small.begin(); it != small.end(); ++it) {
             for (int x = 0; x < 5; ++x) {
                 for (int y = 0; y < 5; ++y) {
                     if (it->a[x][y] == 'X') {
                         my w = *it;
                         if (x > 0 && w.a[x - 1][y] != 'X') {
                             w.a[x - 1][y] = 'X';
                             big.insert(w);
                             figs[size].insert(w.sh());
                             w.a[x - 1][y] = '.';
                         }
                         if (x < 4 && w.a[x + 1][y] != 'X') {
                             w.a[x + 1][y] = 'X';
                             big.insert(w);
                             figs[size].insert(w.sh());
                             w.a[x + 1][y] = '.';
                         }
                         if (y > 0 && w.a[x][y - 1] != 'X') {
                             w.a[x][y - 1] = 'X';
                             big.insert(w);
                             figs[size].insert(w.sh());
                             w.a[x][y - 1] = '.';
                         }
                         if (y < 4 && w.a[x][y + 1] != 'X') {
                             w.a[x][y + 1] = 'X';
                             big.insert(w);
                             figs[size].insert(w.sh());
                             w.a[x][y + 1] = '.';
                         }
                     }
                 }
             }
         }
         small.swap(big);
         big.clear();
     }
 }
 
 bool canFill(char v[20][20], int R, int C, const set<my>& f, int emptyCells, int figCells) {
     if (emptyCells == 0) return true;
     for (int r = 0; r < R; ++r) {
         for (int c = 0; c < C; ++c) {
             if (v[c][r] == '.') {
                 for (set<my>::const_iterator it = f.begin(); it != f.end(); ++it) {
                     if (it->copyTo(v, c - it->off, C, r, R)) {
                         if (emptyCells == figCells) return true;
                         if (canFill(v, R, C, f, emptyCells - figCells, figCells)) return true;
                     }
                     it->clearFrom(v, c - it->off, r);
                 }
             }
         }
     }
     return false;
 }
 
 int solve() {
     int X, R, C;
     cin >> X >> R >> C;
 //    cout << X << ' ' << R << " " << C << "  ";
     if (X >= 6) return RICHARD;
     if ((R * C) % X != 0) return RICHARD;
     const set<my>& f = figs[X];
     for (set<my>::const_iterator it = f.begin(); it != f.end(); ++it) {
         bool couldFill = false;
         for (int r = 0; !couldFill && r < R; ++r) {
             for (int c = 0; !couldFill && c < C; ++c) {
                 char v[20][20];
                 for (int i = 0; i != 20; ++i) {
                     for (int j = 0; j != 20; ++j)
                         v[i][j] = '.';
                 }
                 if (it->copyTo(v, c, C, r, R)) {
                     couldFill = canFill(v, R, C, f, R * C - X, X);
                 }
                 if (!couldFill) {
                     for (int i = 0; i != 20; ++i) {
                         for (int j = 0; j != 20; ++j)
                             v[i][j] = '.';
                     }
                     if (it->copyTo(v, r, R, c, C)) {
                         couldFill = canFill(v, C, R, f, R * C - X, X);
                     }
                 }
             }
         }
         if (!couldFill) return RICHARD;
     }
     return GABRIEL;
 }
 
 int main(int argc, char* argv[]) {
     init();
 
     cin >> T;
     for (int t = 0; t != T; ++t) {
         int s = solve();
         if (s == RICHARD)
             printf("Case #%d: RICHARD\n", t + 1);
         else
             printf("Case #%d: GABRIEL\n", t + 1);
     }
     return 0;
 }
 
