#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <math.h>
 
 #define SIZE 1050
 
 typedef struct {
     int row;
     int col;
 } shape;
 
 int permut(int X, shape* num_splits)
 {
     int row,col,count=0;
     for (row = 1;row <= X - 1; row++)
     {
         col = X-row;
         if (col * row >=X) {
             num_splits[count].row=row;
             num_splits[count].col=col;
             count++;
         }
         col = ceil((float)X/row);
         if (col * row >=X) {
             if (col == num_splits[count-1].col 
                && row == num_splits[count-1].row) continue;
             num_splits[count].row=row;
             num_splits[count].col=col;
             count++;
         }
     }
     return count;
 }
 
 int main(int argc, char **argv) {
     
     int T;
     scanf("%d", &T);
 
     char input[SIZE];
     int X,R,C,i;
     char winner[20]="RICHARD";
     shape *num_splits;
 
     //Main loop
     for (i=0; i < T; i++) {
         scanf("%d %d %d",&X,&R,&C);
         int total_grid = R * C;
         num_splits=(shape*)malloc(sizeof(shape)*SIZE);
               
         int count = permut(X,num_splits);
         int j,flag=0;
         for (j=0 ; j < count; j++) {
             //printf("%d %d,", num_splits[j].row,num_splits[j].col);
             if ((R < num_splits[j].row || C < num_splits[j].col) )
                //|| (C < num_splits[j].row || R < num_splits[j].col))
             {
                 printf("Case #%d: RICHARD\n",i+1);
                 flag =1;
                 break;
             }
         }
         free(num_splits);
         if (flag == 1) continue;
 
         
         if ((total_grid - X) >= X && (total_grid - X) % X == 0)
             printf("Case #%d: GABRIEL\n",i+1);
         else
             printf("Case #%d: RICHARD\n",i+1);
     }
 }
 
 /*
   Algo: 
   Cond 1:if jth value is less than j+1, then add (value-(j+1))
 Algo:
   Count number who stands up
   If curr j is less than the number standing up, +1
 
 
  
 */
