#include <stdio.h>
 #include <string.h>
 #include <stdlib.h>
 
 void dump_board(char **board,int width,int height)
 	{
 	int x,y;
 	for(y=0;y<height;y++)
 		{
 		for(x=0;x<width;x++)
 			{
 			printf("%c",board[y][x]);
 			}
 		printf("\n");
 		}
 	}
 
 char **make_board(int width,int height)
 	{
 	char **board;
 	int x,y,m;
 	if(width>height)
 		{
 		m=width;
 		}
 	else
 		{
 		m=height;
 		}
 	board=(char **) malloc(sizeof(char *)*m);
 	for(y=0;y<height;y++)
 		{
 		board[y]=(char *) malloc(sizeof(char)*m);
 		for(x=0;x<width;x++)
 			{
 			board[y][x]=' ';
 			}
 		}
 	return(board);
 	}
 
 void clean_board(char **board,int width,int height)
 	{
 	int x,y;
 	for(y=0;y<height;y++)
 		{
 		for(x=0;x<width;x++)
 			{
 			board[y][x]=' ';
 			}
 		}
 	}
 
 void free_board(char **board,int height)
 	{
 	int i;
 	for(i=0;i<height;i++)
 		{
 		free(board[i]);
 		}
 	free(board);
 	}
 
 void topleft_align(char **piece,int size)
 	{
 	int x,y;
 	int empty;
 	char *temp;
 
 	empty=size-1;
 	while(empty)
 		{
 		for(x=0;x<size;x++)
 			{
 			if(piece[0][x]!=' ')
 				{
 				empty=0;
 				break;
 				}
 			}
 		if(empty)
 			{
 			for(x=0;x<size;x++)
 				{
 				for(y=0;y<size-1;y++)
 					{
 					piece[y][x]=piece[y+1][x];
 					}
 				piece[size-1][x]=' ';
 				}
 			empty--;
 			}
 		}
 
 	empty=size-1;
 	while(empty)
 		{
 		for(y=0;y<size;y++)
 			{
 			if(piece[y][0]!=' ')
 				{
 				empty=0;
 				break;
 				}
 			}
 		if(empty)
 			{
 			for(y=0;y<size;y++)
 				{
 				for(x=0;x<size-1;x++)
 					{
 					piece[y][x]=piece[y][x+1];
 					}
 				piece[y][size-1]=' ';
 				}
 			empty--;
 			}
 		}
 
 	}
 
 void flip_piece_horiz(char **piece,char **newpiece,int size)
 	{
 	int x,y;
 	for(x=0;x<size;x++)
 		{
 		for(y=0;y<size;y++)
 			{
 			newpiece[y][size-x-1]=piece[y][x];
 			}
 		}
 	topleft_align(newpiece,size);
 	}
 
 void flip_piece_vert(char **piece,char **newpiece,int size)
 	{
 	int x,y;
 	for(x=0;x<size;x++)
 		{
 		for(y=0;y<size;y++)
 			{
 			newpiece[size-y-1][x]=piece[y][x];
 			}
 		}
 	topleft_align(newpiece,size);
 	}
 
 void rotate_piece(char **piece,char **newpiece,int size)
 	{
 	int x,y;
 	for(x=0;x<size;x++)
 		{
 		for(y=0;y<size;y++)
 			{
 			newpiece[x][y]=piece[y][x];
 			}
 		}
 	topleft_align(newpiece,size);
 	}
 
 int _same_piece(char **piece_a,char **piece_b,int size)
 	{
 	int x,y;
 	for(y=0;y<size;y++)
 		{
 		for(x=0;x<size;x++)
 			{
 			if(piece_a[y][x]!=piece_b[y][x])
 				{
 				return(0);
 				}
 			}
 		}
 	return(1);
 	}
 
 int same_piece(char **piece_a,char **piece_b,int size)
 	{
 	char **temp,**temp2;
 	
 /*	dump_board(piece_a,size,size);
 	printf("----\n");
 	dump_board(piece_b,size,size);
 	printf("\n");*/
 	
 	if(_same_piece(piece_a,piece_b,size))
 		{
 		return(1);
 		}
 	temp=make_board(size,size);
 	temp2=make_board(size,size);
 
 	flip_piece_horiz(piece_b,temp,size);
 	if(_same_piece(piece_a,temp,size))
 		{
 		free_board(temp,size);
 		free_board(temp2,size);
 		return(1);
 		}
 	flip_piece_vert(piece_b,temp,size);
 	if(_same_piece(piece_a,temp,size))
 		{
 		free_board(temp,size);
 		free_board(temp2,size);
 		return(1);
 		}
 	flip_piece_horiz(temp,temp2,size);
 	if(_same_piece(piece_a,temp2,size))
 		{
 		free_board(temp2,size);
 		free_board(temp,size);
 		return(1);
 		}
 	rotate_piece(piece_b,temp,size);
 	if(_same_piece(piece_a,temp,size))
 		{
 		free_board(temp,size);
 		free_board(temp2,size);
 		return(1);
 		}
 
 	flip_piece_horiz(temp,temp2,size);
 	if(_same_piece(piece_a,temp2,size))
 		{
 		free_board(temp2,size);
 		free_board(temp,size);
 		return(1);
 		}
 	flip_piece_vert(temp,temp2,size);
 	if(_same_piece(piece_a,temp2,size))
 		{
 		free_board(temp2,size);
 		free_board(temp,size);
 		return(1);
 		}
 	free_board(temp2,size);
 	free_board(temp,size);
 	return(0);
 	}
 
 void place_piece(char **piece,int pw,int ph,char **board,int bw,int bh,int x,int y)
 	{
 	int i,j;
 	
 	for(i=0;i<pw;i++)
 		{
 		for(j=0;j<ph;j++)
 			{
 			if(piece[j][i]=='#')
 				{
 				if((j+y<bh)&&(i+x<bw))
 					{
 					board[j+y][i+x]='#';
 					}
 				else
 					{
 					printf("Die!");
 					exit(0);
 					}
 				}
 			}
 		}
 	}
 
 int can_fit_piece(char **board,int bw,int bh,int x,int y,char **piece,int size)
 	{
 	int i,j;
 	
 	for(i=0;i<size;i++)
 		{
 		for(j=0;j<size;j++)
 			{
 			if((piece[j][i]=='#')&&((j+y>=bh)||(i+x>=bw)||(board[j+y][i+x]=='#')))
 				{
 				return(0);
 				}
 			}
 		}
 	return(1);
 	}
 
 
 void remove_piece(char **piece,int pw,int ph,char **board,int bw,int bh,int x,int y)
 	{
 	int i,j;
 	
 	for(i=0;i<pw;i++)
 		{
 		for(j=0;j<ph;j++)
 			{
 			if(piece[j][i]=='#')
 				{
 				board[j+y][i+x]=' ';
 				}
 			}
 		}
 	}
 
 char ***make_ominos(int size,int *num_pieces)
 	{
 	char ***pieces;
 	if(size==1)
 		{
 		*num_pieces=1;
 		pieces=(char ***) malloc(sizeof(char **)*1);
 		pieces[0]=make_board(size,size);
 		pieces[0][0][0]='#';
 		}
 	else
 		{
 		char ***child_pieces;
 		int num_child_pieces;
 		char **newpiece;
 		int i,x,y,j;
 		
 		child_pieces=make_ominos(size-1,&num_child_pieces);
 		pieces=(char ***) malloc(sizeof(char **)*1);
 		*num_pieces=0;
 		newpiece=make_board(size,size);
 		for(i=0;i<num_child_pieces;i++)
 			{
 			for(x=0;x<size-1;x++)
 				{
 				for(y=0;y<size-1;y++)
 					{
 					if(child_pieces[i][y][x]=='#')
 						{
 						if((x+1>=size-1)||(child_pieces[i][y][x+1]==' '))
 							{
 							place_piece(child_pieces[i],size-1,size-1,newpiece,size,size,0,0);
 							newpiece[y][x+1]='#';
 							topleft_align(newpiece,size);
 							for(j=0;j<(*num_pieces);j++)
 								{
 								if(same_piece(pieces[j],newpiece,size))
 									{
 									break;
 									}
 								}
 							if(j==*num_pieces)
 								{
 								pieces=(char ***) realloc(pieces,sizeof(char **)*((*num_pieces)+1));
 								pieces[*num_pieces]=newpiece;
 								(*num_pieces)++;
 								newpiece=make_board(size,size);
 								}
 							else
 								{
 								clean_board(newpiece,size,size);
 								}
 							}
 						if((x-1<0)||(child_pieces[i][y][x-1]==' '))
 							{
 							place_piece(child_pieces[i],size-1,size-1,newpiece,size,size,1,0);
 							newpiece[y][x]='#';
 							topleft_align(newpiece,size);
 							for(j=0;j<(*num_pieces);j++)
 								{
 								if(same_piece(pieces[j],newpiece,size))
 									{
 									break;
 									}
 								}
 							if(j==*num_pieces)
 								{
 								pieces=(char ***) realloc(pieces,sizeof(char **)*((*num_pieces)+1));
 								pieces[*num_pieces]=newpiece;
 								(*num_pieces)++;
 								newpiece=make_board(size,size);
 								}
 							else
 								{
 								clean_board(newpiece,size,size);
 								}
 							}
 						if((y+1>=size-1)||(child_pieces[i][y+1][x]==' '))
 							{
 							place_piece(child_pieces[i],size-1,size-1,newpiece,size,size,0,0);
 							newpiece[y+1][x]='#';
 							topleft_align(newpiece,size);
 							for(j=0;j<(*num_pieces);j++)
 								{
 								if(same_piece(pieces[j],newpiece,size))
 									{
 									break;
 									}
 								}
 							if(j==*num_pieces)
 								{
 								pieces=(char ***) realloc(pieces,sizeof(char **)*((*num_pieces)+1));
 								pieces[*num_pieces]=newpiece;
 								(*num_pieces)++;
 								newpiece=make_board(size,size);
 								}
 							else
 								{
 								clean_board(newpiece,size,size);
 								}
 							}
 						if((y-1<0)||(child_pieces[i][y-1][x]==' '))
 							{
 							place_piece(child_pieces[i],size-1,size-1,newpiece,size,size,0,1);
 							newpiece[y][x]='#';
 							topleft_align(newpiece,size);
 							for(j=0;j<(*num_pieces);j++)
 								{
 								if(same_piece(pieces[j],newpiece,size))
 									{
 									break;
 									}
 								}
 							if(j==*num_pieces)
 								{
 								pieces=(char ***) realloc(pieces,sizeof(char **)*((*num_pieces)+1));
 								pieces[*num_pieces]=newpiece;
 								(*num_pieces)++;
 								newpiece=make_board(size,size);
 								}
 							else
 								{
 								clean_board(newpiece,size,size);
 								}
 							}
 						}
 					}
 				}
 			free_board(child_pieces[i],size-1);
 			}
 		free_board(newpiece,size);
 		}
 	return(pieces);
 	}
 
 int _solve(char **board,int width,int height,char ***pieces,int size,int num_pieces)
 	{
 	int x,y,i;
 	int ret=0;
 	int placed;
 	char **temp,**temp2;
 	
 	for(x=0;x<width;x++)
 		{
 		for(y=0;y<height;y++)
 			{
 			if(board[y][x]=='#')
 				{
 				ret++;
 				}
 			}
 		}
 	if(ret==width*height)
 		{
 		return(1);
 		}
 	temp=make_board(size,size);
 	temp2=make_board(size,size);
 	for(i=0;i<num_pieces;i++)
 		{
 		placed=0;
 		for(x=0;x<width;x++)
 			{
 			for(y=0;y<height;y++)
 				{
 				if(can_fit_piece(board,width,height,x,y,pieces[i],size))
 					{
 					place_piece(pieces[i],size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(pieces[i],size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 				flip_piece_horiz(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 				flip_piece_vert(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 
 				flip_piece_horiz(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 				rotate_piece(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 			
 				flip_piece_horiz(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 				flip_piece_vert(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					if(placed)
 						{
 						break;
 						}
 					}
 				}
 			if(placed)
 				{
 				break;
 				}
 			}
 		if(placed)
 			{
 			free_board(temp,size);
 			free_board(temp2,size);
 			return(1);
 			}
 		}
 	free_board(temp,size);
 	free_board(temp2,size);
 	return(0);
 	}
 
 int solve(int size,int width,int height)
 	{
 	char **board;
 	int i,x,y;
 	int ret;
 	int placed;
 	char ***pieces;
 	char **temp,**temp2;
 	int num_pieces;
 
 	board=make_board(width,height);
 	pieces=make_ominos(size,&num_pieces);
 
 	ret=0;
 	temp=make_board(size,size);
 	temp2=make_board(size,size);
 	for(i=0;i<num_pieces;i++)
 		{
 		placed=0;
 		for(x=0;x<width;x++)
 			{
 			for(y=0;y<height;y++)
 				{
 				if(can_fit_piece(board,width,height,x,y,pieces[i],size))
 					{
 					place_piece(pieces[i],size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(pieces[i],size,size,board,width,height,x,y);
 					break;
 					}
 				flip_piece_horiz(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					break;
 					}
 				flip_piece_vert(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					break;
 					}
 				flip_piece_horiz(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					break;
 					}
 				rotate_piece(pieces[i],temp,size);
 				if(can_fit_piece(board,width,height,x,y,temp,size))
 					{
 					place_piece(temp,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp,size,size,board,width,height,x,y);
 					break;
 					}
 			
 				flip_piece_horiz(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					break;
 					}
 				flip_piece_vert(temp,temp2,size);
 				if(can_fit_piece(board,width,height,x,y,temp2,size))
 					{
 					place_piece(temp2,size,size,board,width,height,x,y);
 					placed=_solve(board,width,height,pieces,size,num_pieces);
 					remove_piece(temp2,size,size,board,width,height,x,y);
 					break;
 					}
 				}
 			if(placed)
 				{
 				break;
 				}
 			}
 		if(placed)
 			{
 			ret++;
 			}
 		}
 
 	free_board(temp2,size);
 	free_board(temp,size);
 	free_board(board,height);
 	if(ret!=num_pieces)
 		{
 		return(1);
 		}
 	else
 		{
 		return(0);
 		}
 	}
 
 int main(int argc,char *argv[])
 	{
 	int casenum;
 	int tests;
 	int x,r,c;
 	char ***pieces;
 	int num_pieces;
 /*	r=4;
 	pieces=make_ominos(r,&num_pieces);
 	
 	for(x=0;x<num_pieces;x++)
 		{
 		dump_board(pieces[x],r,r);
 		printf("----\n");
 		free_board(pieces[x],r);
 		}
 	printf("%d\n",num_pieces);
 
 	exit(0);*/
 	fscanf(stdin,"%d\n",&tests);
 	for(casenum=1;casenum<=tests;casenum++)
 		{
 		fscanf(stdin,"%d %d %d\n",&x,&r,&c);
 		if(solve(x,c,r))
 			{
 			printf("Case #%d: RICHARD\n",casenum);
 			}
 		else
 			{
 			printf("Case #%d: GABRIEL\n",casenum);
 			}
 		}
 	}
