#include <bits/stdc++.h>
 #define X first
 #define Y second
 
 #define bitAt(a,b) (a & (1<<b))
 
 using namespace std;
 
 typedef long long LL;
 typedef pair <int, int> PII;
 typedef pair <LL,LL> PLL;
 
 const int Maxn = 100 + 250;
 const int Mod = 1000 * 1000 * 1000 + 7;
 const int abMax = 1 << 30 ;
 const double EPS = 1e-9;
 const double PI = acos(-1.0);
 
 ofstream fout ("C-Small.out");
 ifstream fin ("C-small-attempt0.in");
 
 #define cin fin
 #define cout fout
 
 LL dist[Maxn][Maxn];
 LL G[Maxn][Maxn];
 pair < LL , int > horse[Maxn];
 
 int n , q;
 
 void floydWarshall (int n){
 
     for(int i = 0 ; i < n;i++){
         for(int j = 0 ; j < n;j++){
             dist[i][j] = abMax;
             if(G[i][j] != -1)
                 dist[i][j] = G[i][j];
         }
         dist[i][i] = 0;
     }
     for(int k = 0 ; k < n; k++){
         for(int i = 0 ; i < n ; i++){
             for(int j = 0 ; j < n ; j++){
                 if( dist [i][j] > dist [i][k] + dist[k][j]){
                     dist [i][j] = dist [i][k] + dist[k][j];
                 }
             }
         }
     }
 }
 
 double timeN[Maxn];
 bool mark[Maxn];
 
 
 int doHorse (int x){ // returns the node to continue with
 
     int dtime = abMax , di = -1;
     for(int i = 0 ; i < n ; i++){
             //cerr << timeN[i] << endl;
         if(mark[i]) continue;
 
         if(dist[x][i] <= horse[x].X){
             double tmp =  ((double)dist[x][i]/(double)horse[x].Y);
             //cerr << x << ' ' << i << ' ' << tmp << endl;
             if( tmp + timeN[x] < timeN[i] ){
                 timeN[i] = tmp + timeN[x];
             }
         }
         //cerr << timeN[i] << endl;
         //cerr << i << " ------------ " << endl;
         if(timeN[i] < dtime){
             dtime = timeN[i];
             di = i;
         }
     }
     return di;
 }
 
 void query (int start , int goal){
 
     for(int i = 0 ; i < n;i++){
         timeN[i] = abMax;
         mark[i] = false;
     }
 
     timeN[start] = 0;
     mark[start] = true;
 
     int v = doHorse(start);
     //cerr << v << endl;
     /**/
     while(v != goal){
         //cerr << v << endl;
         mark[v] = true;
         v = doHorse(v);
     }
     /**/
 
 }
 
 
 
 
 double ans = 0;
 int T = 0;
 int main() {
 	ios::sync_with_stdio(0);
 	cin >> T;
 	for(int ttt = 1; ttt <= T ; ttt++){
 
         cin >> n >> q;
         for(int i = 0 ; i < n ; i++){
             cin >> horse[i].X >> horse[i].Y;
         }
         for(int i = 0 ; i < n; i++){
             for(int j = 0 ; j < n; j++){
                 cin >> G[i][j];
             }
         }
 
         floydWarshall(n);
         /**
         for(int i = 0 ; i < n ; i++){
             for(int j = 0 ; j < n ; j++){
                 cerr << dist[i][j] << ' ';
             }
             cerr << endl;
         }
         /**/
         cout << "Case #" << ttt << ":";
 
         for(int i = 0 ; i < q ; i++){
             int s , f;
             cin >> s >> f;
             s--; f--;
             query(s,f);
             cout << ' ' << fixed << setprecision(6) << timeN[f];
         }
         cout << endl;
 
 	}
 }
 
