#include <fstream>
 #include <algorithm>
 #include <vector>
 #include <sstream> 
 #include <queue>
 #include <iomanip>
 
 
 using namespace std;
 
 string input;
 vector<string> etapes;
 string output;
 ifstream is("test.in");
 ofstream error("error.txt");
 ofstream out("out.out");
 int nbTest;
 
 int nbCities;
 int nbDelivery;
 struct City {
 	int totalDistance;
 	int speed;
 	vector<int> distanceFromNeighbour;
 	City(int totalDistance_, int speed_) {
 		totalDistance = totalDistance_;
 		speed = speed_;
 	}
 };
 
 struct Test {
 	int begin;
 	int end;
 	Test(int begin_, int end_) {
 		begin = begin_;
 		end = end_;
 	}
 };
 
 void executeOneInput(){
 	vector<City> cities;
 	vector<Test> tests;
 	is >> nbCities >> nbDelivery;
 	for (int i = 0; i < nbCities; i++) {
 		int totalDistance;
 		int speed;
 		is >> totalDistance >> speed;
 		cities.push_back(City(totalDistance, speed));
 	}
 	for (int i = 0; i < nbCities; i++) {
 		for (int j = 0; j < nbCities; j++) {
 			int distance;
 			is >> distance;
 			cities[i].distanceFromNeighbour.push_back(distance);
 		}
 	}
 	for (int i = 0; i < nbDelivery; i++) {
 		int begin;
 		int end;
 		is >> begin >> end;
 		tests.push_back(Test(begin, end));
 	}
 	struct Node {
 		int iCity;
 		int speed;
 		double totalDistance;
 		double time;
 	}; 
 	struct Cmp{
 		bool operator() (const Node& lhs, const Node&rhs) const{
 			return (lhs.time>rhs.time);
 		}
 	};
 	for (int i = 0; i < nbDelivery; i++) {
 		priority_queue<Node, std::vector<Node>, Cmp> possibilities;
 		Node node;
 		node.iCity = tests[i].begin-1;
 		node.speed = cities[node.iCity].speed;
 		node.totalDistance = cities[node.iCity].totalDistance;
 		node.time = 0;
 		possibilities.push(node);
 		while (!possibilities.empty()) {
 			Node currentNode = possibilities.top();
 			possibilities.pop();
 			if (currentNode.iCity == tests[i].end-1) {
 				stringstream  ss;
 				ss << fixed << setprecision(6) << currentNode.time;
 				if (i != 0)
 					output += " ";
 				output += ss.str();
 				break;
 			}
 			for (int j = 0; j < nbCities; j++) {
 				int dist = cities[currentNode.iCity].distanceFromNeighbour[j];
 				if (dist != -1) {
 					double time = (double)dist /(double)currentNode.speed;
 					if (time <= currentNode.totalDistance) {
 						Node node;
 						node.iCity = j;
 						node.speed = currentNode.speed;
 						node.totalDistance = currentNode.totalDistance;
 						node.time = currentNode.time + time;
 						possibilities.push(node);
 					}
 					time = (double)dist / (double)cities[currentNode.iCity].speed;
 					if (time <= cities[currentNode.iCity].totalDistance) {
 						Node node;
 						node.iCity = j;
 						node.speed = currentNode.speed;
 						node.totalDistance = currentNode.totalDistance;
 						node.time = currentNode.time + time;
 						possibilities.push(node);
 					}
 
 				}
 			}
 		}
 
 
 
 	}
 
 }
 int main(int argc, char* argv[]){
 	is >> nbTest;
 
 	for(int i=0;i<nbTest;i++){
 		executeOneInput();
 		out << "Case #" << i + 1 << ": " << output << endl;
 
 	}
 }
