#include <iostream>
 #include <vector>
 
 using namespace std;
 
 int t;
 
 double dfs(const vector<vector<int> > & distances, const vector<pair <int, int> > & horses, int from, int to, const vector<bool> & travelled, int currentHorse = -1) {
   if (from == to) {
     return 0;
   }
 
   double ret = 1000000000;
 
   for (int i = 1; i < distances[from].size(); ++i) {
     int distance = distances[from][i];
 
     if (distance != -1 && !travelled[i]) {
       if (currentHorse == -1) {
         currentHorse = from;
       }
 
       double current = 1000000000;
 
       if (horses[currentHorse].first >= distance) {
         vector<pair <int, int> > nextHorses = horses;
         nextHorses[currentHorse].first -= distance;
         vector<bool> nextTravelled = travelled;
         nextTravelled[i] = true;
         current = (distance * 1.0 / nextHorses[currentHorse].second) + dfs(distances, nextHorses, i, to, nextTravelled, currentHorse);
       }
 
       double next = 1000000000;
       
       if (horses[i].first >= distance) {
         vector<pair <int, int> > nextHorses = horses;
         nextHorses[i].first -= distance;
         vector<bool> nextTravelled = travelled;
         nextTravelled[i] = true;
         next = (distance * 1.0 / nextHorses[i].second) + dfs(distances, nextHorses, i, to, nextTravelled, i);        
       }
 
       if (ret > current) {
         ret = current;
       }
 
       if (ret > next) {
         ret = next;
       }
     }
   }
 
   return ret;
 }
 
 int main() {
   scanf("%d\n", &t);
   for (int i = 1; i <= t; ++i) {
     int n, q;
     scanf("%d %d\n", &n, &q);
     vector<pair <int, int > > cities(n + 1);
     for (int j = 1; j <= n; ++j) {
       int s, v;
       scanf("%d %d\n", &s, &v);
       cities[j] = make_pair(s, v);
     }
     vector<vector<int> > distances(n + 1);
     for (int j = 1; j <= n; ++j) {
       distances[j].push_back(0);
       for (int k = 1; k <= n; ++k) {
         int dist;
         scanf("%d", &dist);
         distances[j].push_back(dist);
       }
       scanf("\n");
     }
     double total = 0;
 
     vector<pair<int, int> > queues(n + 1);
     for (int j = 1; j <= q; ++j) {
       int from, to;
       scanf("%d %d\n", &from, &to);
       vector<bool> travelled(n + 1);
       total += dfs(distances, cities, from, to, travelled);
 
       printf("Case #%d: %.9f\n", i, total);
     }
   }
   return 0;
 }