#include <algorithm>
 #include <bitset>
 #include <cassert>
 #include <deque>
 #include <queue>
 #include <iomanip>
 #include <iostream>
 #include <iterator>
 #include <float.h>
 #include <limits>
 #include <list>
 #include <map>
 #include <math.h>
 #include <numeric>
 #include <set>
 #include <sstream>
 #include <stack>
 #include <stdio.h>
 #include <string>
 #include <vector>
 
 using namespace std;
 
 typedef long long ll;
 typedef unsigned long long ull;
 typedef pair<int, int> pi;
 typedef pair<ll, ll> pl;
 typedef vector<bool> vb;
 typedef vector<int> vi;
 typedef vector<unsigned> vu;
 typedef vector<ll> vl;
 typedef vector<pi> vp;
 typedef vector<string> vs;
 typedef set<int> si;
 typedef map<int, int> mi;
 typedef priority_queue < pi, vector<pi>, greater<pi> > pqpi;
 
 const int MAX_N = 100;
 
 int am[MAX_N][MAX_N];
 
 void solve(int t)
 {
 	int n, q;
 	cin >> n >> q;
 
 	vi e(n);
 	vi s(n);
 	for (int i = 0; i < n; ++i)
 	{
 		cin >> e[i] >> s[i];
 	}
 
 	for (int i = 0; i < n; ++i)
 	{
 		for (int j = 0; j < n; ++j)
 		{
 			cin >> am[i][j];
 		}
 	}
 
 
 	cout << "Case #" << t + 1 << ": ";
 
 	for (int i = 0; i < q; ++i)
 	{
 		int u, v;
 		cin >> u >> v;
 		--u;
 		--v;
 
 
 		double res = 0;
 
 		for (int to = v; to;)
 		{
 			int from = to - 1;
 			ll dist = am[from][to];
 
 			int fastest_i = -1;
 			int fastest_speed = 0;
 			ll fastest_dist = -1;
 
 			if (e[from] >= dist)
 			{
 				fastest_i = from;
 				fastest_speed = s[from];
 				fastest_dist = dist;
 			}
 
 			while (from)
 			{
 				dist += am[from - 1][from];
 				if (dist <= e[from - 1])
 				{
 					if (fastest_speed < s[from - 1])
 					{
 						fastest_speed = s[from - 1];
 						fastest_i = from - 1;
 						fastest_dist = dist;
 					}
 				}
 				--from;
 			}
 			res += (double)fastest_dist / (double)fastest_speed;
 			to = fastest_i;
 		}
 
 		cout << setprecision(17) << res << " ";
 	}
 
 	cout << endl;
 }
 
 int main(int argc, char* argv[])
 {
 	int t;
 	cin >> t;
 
 	for (int i = 0; i < t; ++i)
 	{
 		solve(i);
 	}
 	return 0;
 }
