#include <cstdio>
 #include <algorithm>
 
 #define INF (1.5e9)
 #define N 111
 
 int T, n, q, m[N], s[N];
 double d[N], qs[N];
 double dp[N][N];
 
 bool possible(int u, int h)
 {
     return qs[u+1]-qs[h] <= m[h] && h <= u;
 }
 
 double traverse(int u, int h)
 {
     if (!possible(u, h))
         return INF;
     if (u == n)
         return 0;
     if (dp[u][h] != INF)
         return dp[u][h];
     
     return dp[u][h] = std::min(
         traverse(u+1, u+1),
         traverse(u+1, h)
     ) + (d[u+1]/(double)s[h]);
 }
 
 int main()
 {
     scanf("%d", &T);
     for (int t = 1; t <= T; ++t) {
 
         scanf("%d%d", &n, &q); // q = 1
         
         // horse
         for (int i = 1; i <= n; ++i)
             scanf("%d%d", &m[i], &s[i]);
         
         // dist
         qs[0] = qs[1] = d[n] = d[n+1] = qs[n] = qs[n+1] = 0;
         for (int i = 1; i <= n; ++i) {
             for (int j = 1; j <= n; ++j) {
                 int x;
                 scanf("%d", &x);
                 if (x == -1)
                     x = INF;
                 else {
                     d[i+1] = x;
                     qs[i+1] = qs[i]+d[i+1];
                 }
             }
         }
 
         // query (q = 1)
         int u, v;
         scanf("%d%d", &u, &v);
 
         for (int i = 1; i <= n; ++i) {
             for (int j = 1; j <= n; ++j)
                 dp[i][j] = INF;
         }
 
         printf("Case #%d: %.7lf\n", t, traverse(1, 1));
         /*for (int i = 1; i <= n; ++i) {
             for (int j = 1; j <= n; ++j)
                 printf("%.7lf ", traverse(i, j));
             printf("\n");
         }*/
         fprintf(stderr, "case %d done\n", t);
 
     }
     return 0;
 }