#include <vector>
 #include <iostream>
 #include <fstream>
 #include <string>
 #include <algorithm>
 #include <cmath>
 #include <limits>
 #include <iomanip>
 #include <stdint.h>
 
 using namespace std;
 
 #define RED 1
 #define YELLOW 2
 #define BLUE 3
 
 typedef long long ll;
 typedef vector<int> vi;
 typedef vector<bool> vb;
 typedef vector<vi> vvi;
 typedef vector<vb> vvb;
 
 ifstream fin;
 ofstream fout;
 
 void init(string inputFile, string outputFile)
 {
 	fin.open(inputFile);
 	fout.open(outputFile);
 }
 
 void end()
 {
 	fin.close();
 	fout.close();
 }
 
 int main()
 {
 	init("C-small-attempt2.in", "output.txt");
 	int T;
 	fin >> T;
 	for (int t = 0; t < T; t++)
 	{
 		int n, q;
 		fin >> n >> q;
 		cout << n << endl;
 		vector<double> dis(n);
 		vector<double> speed(n);
 		vector<double> edge(n - 1);
 		vector<double> maxRes(n - 1);
 		for (int i = 0; i < n; i++)
 		{
 			fin >> dis[i] >> speed[i];
 		}
 		for (int i = 0; i < n; i++)
 		{
 			for (int j = 0; j < n; j++)
 			{
 				int temp;
 				fin >> temp;
 				if (i + 1 == j)
 				{
 					edge[i] = temp;
 				}
 			}
 		}
 		for (int i = 0; i < q; i++)
 		{
 			int temp;
 			fin >> temp >> temp;
 		}
 		for (int i = n - 2; i > -1; i--)
 		{
 			uint32_t temp = -1;
 			double bestRes = temp;
 			double time = 0;
 			for (int j = i + 1; j < n; j++)
 			{
 				time += (edge[j - 1] / speed[i]);
 				dis[i] -= edge[j - 1];
 				if (dis[i] < 0)
 					break;
 				if ( (j < n - 1))
 				{
 					bestRes = min(bestRes, time + maxRes[j]);
 				}
 				if (j == n - 1)
 				{
 					bestRes = min(bestRes, time);
 				}
 			}
 
 			maxRes[i] = bestRes;
 
 		}
 		fout << "Case #" << t + 1 << ": ";
 		
 		fout << fixed << setprecision(6);
 	
 		///cout << t + 1 << endl;
 		//cout << "aa" << endl;
 		
 		double temp = maxRes[0];
 		//cout << "aaaaa" << endl;
 		//cout << n  << "aa"<< endl;
 		//cout << temp << endl;
 		fout << maxRes[0] << endl;
 		
 	}
 	end();
 	return 0;
 }