#include <vector>
 #include <string>
 #include <stdlib.h>
 #include <math.h>
 #include <iostream>
 #include <fstream>
 #include <algorithm>
 #include <sstream>
 #include <map>
 #include <ctime>
 #include <cassert>
 
 using namespace std;
 
 ofstream fout("../../../output.txt");
 ifstream fin("../../../input.txt");
 
 typedef long long ll;
 
 ll xv[200];
 ll yv[200];
 ll bv[200];
 ll mod = 1000000007;
 int n;
 ll d;
 
 ll xrange[202];
 ll yrange[202];
 
 ll closest(ll a, ll b)
 {
     ll best = 0;
     int ret = -1;
     for(int i=0; i<n; i++)
     {
         ll diff = (abs(a-xv[i])+abs(b-yv[i]))*d+bv[i];
         if(diff<best || ret==-1)
         {
             best=diff;
             ret=i;
         }
     }
     return best;
 }
 
 ll calcdiff(ll p, ll q, ll n, bool tie)
 {
     if(n==0)
     {
         if(tie)
             return 0;
         return -1;
             
     }
     ll score = n*d + q-p;
     if(score<0)
         return -1;
     if(score%(2*d)!=0 || tie)
     {
         return score/(2*d);
     }
     
     return (score/(2*d))-1;
 }
 
 ll evalrect( ll p, ll xdist, ll ydist)
 {
     ll ret = p*xdist;
     ret%=mod;
     ret*=ydist;
     ret%=mod;
     
     ll a = (ydist*(ydist-1))/2;
     a%=mod;
     a*=xdist;
     
     ll b= (xdist*(xdist-1))/2;
     b%=mod;
     b*=ydist;
     
     a%=mod;
     b%=mod;
     ret+=(a+b)*d;
     ret%=mod;
     return ret;
 }
 
 ll evaltriangle(ll p, ll d1, ll d2)
 {
     ll pnew = p+(d1*d);
     pnew%=mod;
     ll range = (d1-d2);
     if(range==0)
         return 0;
     ll ret = (range*(range+1))/2;
     ret%=mod;
     ret*=pnew;
     ret%=mod;
     
     ll a = range;
     ll b = range+1;
     ll c = range-1;
     
     if(a%3==0)
         a/=3;
     else if(b%3==0)
         b/=3;
     else
         c/=3;
     c*=b;
     c%=mod;
     c*=a;
     c%=mod;
     
     
     ret-=(c*d)%mod;
     ret%=mod;
     ret+=mod;
     ret%=mod;
     return ret;
     
     
 }
 
 
 ll calc(ll p, ll q, ll r, ll s, bool xtie, bool ytie, bool xytie, ll xdiff, ll ydiff)
 {
     ll xdist = calcdiff(p,q,xdiff,xtie);
     ll ydist = calcdiff(p,r,ydiff,ytie);
     ll xydist = calcdiff(p,s,xdiff+ydiff,xytie);
     if(xdist > xydist)
         xdist=xydist;
     if(ydist> xydist)
         ydist=xydist;
     if(xdist <0 || ydist < 0)
         return 0;
     if(xydist > xdist+ydist)
     {
         xydist=xdist+ydist;
     }
     
     //cout << p << " " <<  xdist << " " << ydist << " " << xydist << " ";
     ll ret = evalrect(p,xdist+1,ydist+1);
     //cout << ret << " ";
     ret -= evaltriangle(p,xdist+ydist,xydist);
     ret+=mod;
     ret%=mod;
     //cout << ret << endl;
     return ret;
     
     
 }
 
 int test(int mnx, int mxx, int mny, int mxy)
 {
     int ret = 0;
     for(int i=mnx; i<mxx; i++)
     {
         for(int j=mny; j<mxy; j++)
         {
             ret+=closest(i,j);
         }
     }
     return ret;
 }
 
 ll eval(ll mnx, ll mxx, ll mny, ll mxy)
 {
     ll xdiff = mxx-mnx-1;
     ll ydiff = mxy-mny-1;
     ll p = closest(mnx,mny);
     ll q = closest(mnx,mxy-1);
     ll r = closest(mxx-1,mny);
     ll s = closest(mxx-1,mxy-1);
     //cout << p << " " << q <<  " " << r << " " << s << endl;
     ll ret = 0;
     ret+=calc(p,q,r,s,true,true,true,ydiff,xdiff);
     //cout << ret << " ";
     ret+=calc(q,p,s,r,false,true,true,ydiff,xdiff);
    // cout << ret << " ";
     ret+=calc(r,s,p,q,true,false,false,ydiff,xdiff);
     //cout << ret << " ";
     ret+=calc(s,r,q,p,false,false,false,ydiff,xdiff);
     //cout << ret << " ";
     ret%=mod;
     
     //cout << mnx << " " << mxx << " " << mny << " " << mxy << " " << ret << " " << test(mnx,mxx,mny,mxy) << endl;
     
     return ret;
     
     
 }
 
 int main(void)
 {
     int ttt=0;
     fin >> ttt;
     int ct = 0;
     
     
     cout.precision(9);
     fout.precision(9);
     
     cout << "HELLO" <<  " " << ttt << endl;
     
     
     
     while(ttt>0)
     {
         ct++;
         ttt--;
         
         int i,j,k;
         
         n = 0;
         int r,c;
         
         fin >>  r >> c >> n >> d;
         for(i=0; i<n; i++)
         {
             
         
             fin >> xv[i] >> yv[i] >> bv[i];
             xv[i]--;
             yv[i]--;
             xrange[i]=xv[i];
             yrange[i]=yv[i];
         }
         xrange[n]=0;
         xrange[n+1]=r;
         yrange[n]=0;
         yrange[n+1]=c;
         sort(xrange,xrange+n+2);
         sort(yrange,yrange+n+2);
         
         bool isok = true;
         
         for(i=0; i<n; i++)
         {
             for(j=i+1; j<n; j++)
             {
                 ll p = abs(xv[i]-xv[j])+abs(yv[i]-yv[j]);
                 if(abs(bv[i]-bv[j])>p*d)
                     isok=false;
             }
         }
         
         if(!isok)
         {
             cout << "Case #" << ct << ": IMPOSSIBLE";
             fout << "Case #" << ct << ": IMPOSSIBLE";
             
             cout << endl;
             fout << endl;
             
             continue;
         }
         
         ll ret = 0;
         
         for(int idx1=0; idx1<n+1; idx1++)
         {
             if(xrange[idx1]==xrange[idx1+1])
                 continue;
             for(int idx2=0; idx2<n+1; idx2++)
             {
                 if(yrange[idx2]==yrange[idx2+1])
                     continue;
                 ll mnx = xrange[idx1];
                 ll mxx=  xrange[idx1+1];
                 ll mny = yrange[idx2];
                 ll mxy = yrange[idx2+1];
                 
                 ret+=eval(mnx,mxx,mny,mxy);
                 ret%=mod;
             }
         }
         
         /*ll tmp  =0;
         
         for(i=0; i<r; i++)
         {
             for(j=0; j<c; j++)
             {
                 tmp += closest(i,j);
                 tmp%=mod;
             }
         }
         if(tmp!=ret)
         {
             cout << "ERROR " << endl;
             cout << tmp << " " << ret << " " << ct << " " << r << " " << c << " " << n << " " << bv[0] << endl;
         }*/
         
         
         cout << "Case #" << ct << ": ";
         fout << "Case #" << ct << ": ";
         
         cout <<ret;
         fout << ret;
         
         cout << endl;
         fout << endl;
         
         
         
         
         
     }
     
     
     return 0;
 }
 
