#include <algorithm>
 #include <iostream>
 #include <queue>
 #include <vector>
 
 int main() {
 	const long long mod = 1000000007;
 	std::ios_base::sync_with_stdio(false);
 	int t;
 	std::cin >> t;
 	typedef std::pair<long long, std::pair<int, int>> Pos;
 	std::priority_queue<Pos, std::vector<Pos>, std::greater<Pos>> q;
 	for (int testCase = 1; testCase <= t; testCase++) {
 		long long result = 0;
 		int r, c, n, d;
 		std::cin >> r >> c >> n >> d;
 		std::vector<std::vector<long long>> val(r, std::vector<long long>(c));
 		for (int i = 0; i < n; i++) {
 			int y, x, b;
 			std::cin >> y >> x >> b;
 			y--;
 			x--;
 			val[y][x] = b;
 			q.emplace(b, std::make_pair(y, x));
 			result = (result + b) % mod;
 		}
 		bool ok = true;
 		while (!q.empty()) {
 			Pos p = q.top();
 			q.pop();
 			int y = p.second.first, x = p.second.second;
 			long long b = p.first + d;
 			if (y) {
 				if (val[y - 1][x]) {
 					ok &= val[y - 1][x] <= b;
 				} else {
 					val[y - 1][x] = b;
 					q.emplace(b, std::make_pair(y - 1, x));
 					result = (result + b) % mod;
 				}
 			}
 			if (y + 1 != r) {
 				if (val[y + 1][x]) {
 					ok &= val[y + 1][x] <= b;
 				} else {
 					val[y + 1][x] = b;
 					q.emplace(b, std::make_pair(y + 1, x));
 					result = (result + b) % mod;
 				}
 			}
 			if (x) {
 				if (val[y][x - 1]) {
 					ok &= val[y][x - 1] <= b;
 				} else {
 					val[y][x - 1] = b;
 					q.emplace(b, std::make_pair(y, x - 1));
 					result = (result + b) % mod;
 				}
 			}
 			if (x + 1 != c) {
 				if (val[y][x + 1]) {
 					ok &= val[y][x + 1] <= b;
 				} else {
 					val[y][x + 1] = b;
 					q.emplace(b, std::make_pair(y, x + 1));
 					result = (result + b) % mod;
 				}
 			}
 		}
 		std::cout << "Case #" << testCase << ": ";
 		if (ok)
 			std::cout << result << std::endl;
 		else
 			std::cout << "IMPOSSIBLE" << std::endl;
 	}
 	return 0;
 }
