#include <bits/stdc++.h>
 #define SZ(x) ((int) (x).size())
 using namespace std;
 
 const int MOD = (int) 1e9 + 7;
 
 struct Cell {
     int x, y;
     Cell() = default;
     Cell(int _x, int _y):
         x(_x), y(_y) {}
     bool operator<(const Cell& o) const {
         return x < o.x || (x == o.x && y < o.y);
     }
 };
 
 void solve() {
     int n, m, k, D;
     cin >> n >> m >> k >> D;
 
     vector<Cell> start;
     vector<vector<int64_t>> dist(n, vector<int64_t>(m, 1LL << 62));
     vector<vector<int64_t>> init(n, vector<int64_t>(m, -1));
     for (int i = 0; i < k; ++i) {
         int x, y, c;
         cin >> x >> y >> c;
         x--; y--;
         start.push_back(Cell(x, y));
         init[x][y] = c;
         dist[x][y] = c;
     }
     priority_queue<pair<int64_t, Cell>> q;
     for (const Cell& c: start) {
         q.push(make_pair(-dist[c.x][c.y], c));
     }
     const int dx[] = {-1, 0, 1, 0};
     const int dy[] = {0, 1, 0, -1};
     while (!q.empty()) {
         Cell node = q.top().second;
         int64_t cost = -q.top().first;
         q.pop();
         if (dist[node.x][node.y] != cost) {
             continue;
         }
         for (int d = 0; d < 4; ++d) {
             int nx = node.x + dx[d];
             int ny = node.y + dy[d];
             if (0 <= nx && nx < n && 0 <= ny && ny < m &&
                     dist[nx][ny] > dist[node.x][node.y] + D) {
                 dist[nx][ny] = dist[node.x][node.y] + D;
                 q.push(make_pair(-dist[nx][ny], Cell(nx, ny)));
             }
         }
     }
     int ans = 0;
     for (int i = 0; i < n; ++i) {
         for (int j = 0; j < m; ++j) {
             if (init[i][j] != -1 && init[i][j] != dist[i][j]) {
                 cout << "IMPOSSIBLE\n";
                 return;
             }
             for (int d = 0; d < 4; ++d) {
                 int nx = i + dx[d];
                 int ny = j + dy[d];
                 if (0 <= nx && nx < n && 0 <= ny && ny < m &&
                         abs(dist[i][j] - dist[nx][ny]) > D) {
                     cout << "IMPOSSIBLE\n";
                     return;
                 }
             }
             ans += dist[i][j] % MOD;
             ans %= MOD;
         }
     }
     cout << ans << '\n';
 }
 
 int main() {
     #ifdef LOCAL_RUN
     freopen("task.in", "r", stdin);
     freopen("task.out", "w", stdout);
     //freopen("task.err", "w", stderr);
     #endif // ONLINE_JUDGE
     ios::sync_with_stdio(false);
     cin.tie(0);
 
     int t;
     cin >> t;
 
     for (int _t = 1; _t <= t; ++_t) {
         cout << "Case #" << _t << ": ";
         solve();
     }
 }
