#include <bits/stdc++.h>
 
 using namespace std;
 
 using ll = long long;
 using pii = pair<int, int>;
 using pll = pair<ll, ll>;
 using ld = long double;
 using i128 = __int128;
 
 const ll INF = (ll)1e18;
 const ll MOD = 1000 * 1000 * 1000 + 7;
 const string I = "IMPOSSIBLE";
 
 int mabs(int a) {
     return a > 0 ? a : -a;
 }
 
 struct Solver {
     void solve() {
         int r, c;
         cin >> r >> c;
         int n;
         ll d;
         cin >> n >> d;
         vector<vector<ll>> low(r, vector<ll>(c, 1));
         vector<vector<ll>> high(r, vector<ll>(c, INF));
         for (int rep = 0; rep < n; rep++) {
             int x, y;
             ll b;
             cin >> x >> y >> b;
             --x;
             --y;
             for (int i = 0; i < r; i++)
                 for (int j = 0; j < c; j++) {
                     ll dist = mabs(i - x) + mabs(j - y);
                     low[i][j] = max(low[i][j], b - dist * d);
                     high[i][j] = min(high[i][j], b + dist * d);
                 }
         }
         for (int i = 0; i < r; i++)
             for (int j = 0; j < c; j++)
                 if (low[i][j] > high[i][j]) {
                     cout << I << "\n";
                     return;
                 }
         ll res = 0;
         for (int i = 0; i < r; i++)
             for (int j = 0; j < c; j++) {
                 res += high[i][j] % MOD;
                 res %= MOD;
             }
         cout << res << "\n";
     }
 };
 
 int main() {
     ios_base::sync_with_stdio(0);
     cin.tie(nullptr);
     cout.setf(ios::fixed);
     cout.precision(20);
     int ts;
     cin >> ts;
     for (int t = 1; t <= ts; t++) {
         cout << "Case #" << t << ": ";
         Solver solver;
         solver.solve();
     }
 }
