﻿#include <iostream>
 #include <algorithm>
 #include <set>
 #include <vector>
 #include <string>
 #include <cmath>
 #include <map>
 
 #define X first
 #define Y second
 
 using namespace std;
 
 typedef long long ll;
 typedef long double ld;
 
 const ll mod = 1e9 + 7;
 const ll inf = 3e9;
 
 const long double eps = 1e-18;
 
 
 int main() {
     freopen("input.txt", "r", stdin);
     freopen("output.txt", "w", stdout);
 
     int q;
     cin >> q;
     for (int qq = 0; qq < q; ++qq) {
         ll r, c, n, d;
         cin >> r >> c >> n >> d;
         
         vector<vector<ll> > a(r + 2, vector<ll> (c + 2, inf));
         vector<vector<bool> > b(r + 2, vector<bool> (c + 2, 1));
 
         for (int i = 0; i < n; ++i) {
             ll x, y, w;
             cin >> x >> y >> w;
             a[x][y] = w;
             b[x][y] = 0;
         }
 
         ll sum = 0;
         for (int rt = 0; rt < 1000; ++rt)
             for (int i = 1; i < r + 1; ++i)
                 for (int j = 1; j < c + 1; ++j) {
                     if (b[i + 1][j])
                         a[i + 1][j] = min(a[i + 1][j], a[i][j] + d);
                         
                     if (b[i - 1][j])
                         a[i - 1][j] = min(a[i - 1][j], a[i][j] + d);
                         
                     if (b[i][j + 1])
                         a[i][j + 1] = min(a[i][j + 1], a[i][j] + d);
                         
                     if (b[i][j - 1])
                         a[i][j - 1] = min(a[i][j - 1], a[i][j] + d);   
                 }
 
         bool fl = 0;
         for (int i = 1; i < r + 1; ++i) 
             for (int j = 1; j < c + 1; ++j) {
                 ll delta = 0;
                 if (i > 1)
                     delta = max(delta, abs(a[i][j] - a[i - 1][j]));
                 if (i < r)
                     delta = max(delta, abs(a[i][j] - a[i + 1][j]));
                 if (j < c)
                     delta = max(delta, abs(a[i][j] - a[i][j + 1]));
                 if (j > 1)
                     delta = max(delta, abs(a[i][j] - a[i][j - 1]));
                 if (delta > d)
                     fl = 1;
 
                 sum += a[i][j];
                 sum %= mod;
             }
 
         if (fl) 
             cout << "Case #"<< qq + 1 << ": IMPOSSIBLE\n";
         else
             cout << "Case #" << qq + 1 << ": " << sum << endl;
     }
 
     return 0;
 }
