#include <iostream>
 #include <vector>
 #include <map>
 
 using namespace std;
 
 void update(long long& a, long long b)
 {
     if (a == -1 || a > b)
     {
         a = b;
     }
 }
 
 int main()
 {
     int T;
 
     cin >> T;
     for (int ct = 0; ct < T; ++ct)
     {
         int r, c, n, d;
         cin >> r >> c >> n >> d;
         vector<vector<long long>> v(r, vector<long long>(c, 1000000000000000000ll));
         vector<vector<bool>> fixed(r, vector<bool>(c, false));
 
         for (int i = 0; i < n; ++i)
         {
             int x, y;
             long long z;
             cin >> x >> y >> z;
             x--;
             y--;
             v[x][y] = z;
             fixed[x][y] = true;
         }
 
         while (true)
         {
             bool modified = false;
 
             for (int i = 0; i < r; ++i)
                 for (int j = 0; j < c; ++j)
                     if (!fixed[i][j])
                     {
                         long long mi = -1;
                         long long ma = 0;
                         if (i - 1 >= 0)
                         {
                             update(mi, v[i - 1][j]);
                             ma = max(ma, v[i - 1][j]);
                         }
                         if (i + 1 < r)
                         {
                             update(mi, v[i + 1][j]);
                             ma = max(ma, v[i + 1][j]);
                         }
                         if (j - 1 >= 0)
                         {
                             update(mi, v[i][j - 1]);
                             ma = max(ma, v[i][j - 1]);
                         }
                         if (j + 1 < c)
                         {
                             update(mi, v[i][j + 1]);
                             ma = max(ma, v[i][j + 1]);
                         }
                         if (mi + d != v[i][j])
                         {
                             v[i][j] = mi + d;
                             modified = true;
                         }
                     }
 
             if (!modified)
             {
                 break;
             }
         }
 
         bool fail = false;
         for (int i = 0; i < r; ++i)
             for (int j = 0; j < c; ++j)
             {
                 if (i + 1 < r)
                 {
                     long long D = v[i][j] - v[i + 1][j];
                     if (D < 0) D = -D;
                     if (D > d)
                     {
                         fail = true;
                     }
                 }
                 if (j + 1 < c)
                 {
                     long long D = v[i][j] - v[i][j + 1];
                     if (D < 0) D = -D;
                     if (D > d)
                     {
                         fail = true;
                     }
                 }
             }
 
         if (fail)
         {
             cout << "Case #" << (ct + 1) << ": IMPOSSIBLE" << endl;
         }
         else
         {
             long long total = 0;
             for (int i = 0; i < r; ++i)
                 for (int j = 0; j < c; ++j)
                 {
                     total += v[i][j];
                 }
             cout << "Case #" << (ct + 1) << ": " << total % 1000000007 << endl;
         }
     }
     return 0;
 }
