#include <string>
 #include <vector>
 #include <cstring>
 #include <cmath>
 #include <utility>
 #include <algorithm>
 #include <set>
 #include <map>
 #include <cstdio>
 #include <cstdlib>
 #include <iostream>
 #include <sstream>
 #include <list>
 #include <iomanip>
 #include <ctime>
 #include <cassert>
 #include <stack>
 #include <unordered_map>
 #include <unordered_set>
 
 #pragma comment(linker, "/STACK:2000000")
 
 #define what_is(x) cout << #x << " is " << x << endl;
 
 using namespace std;
 
 typedef long long ll;
 
 unordered_map<ll,ll> mp;
 
 inline ll power(long long a, long long b, long long mod) {
   long long ans=1;
   long long bin[64], i=0;
   while (b>0) {
     bin[i++] = b%2;
     b /= 2;
   }
   for (long long j=i-1; j>=0; j--) {
     ans = (ans*ans)%mod;
     if (bin[j] == 1) {
       ans = (ans*a)%mod;
     }
   }
   return ans;
 }
 
 ll get_digits(ll n) {
   ll ans = 0;
   while (n > 0) {
     ans++;
     n /= 10;
   }
   return ans;
 }
 
 ll reverse_num(ll n) {
   ll ans = 0, cur = 0;
   while (n > 0) {
     ans = ans * 10 + n % 10;
     n /= 10;
     cur++;
   }
   return ans;
 }
 
 ll get_top_digit(ll n) {
   ll digits = get_digits(n), ld = 0;
   ll nc = n;
   while (nc > 0) {
     ld = nc % 10;
     nc /= 10;
   }
   if (ld * power(10, digits - 1, 1e18) == n) {
     return ld - 1;
   }
   return ld;
 }
 
 ll keep(ll n, ll dig) {
   ll cur = n, ans = n;
   for (ll i = 0; i < dig; i++) {
     ll v = cur % 10;
     ans = ans - power(10, i, 1e18) * v;
     cur /= 10;
   }
   return ans;
 }
 
 ll get_ans(ll n) {
   if (n == 0) {
     return 0;
   }
   if (mp.find(n) != mp.end()) {
     return mp[n];
   }
   // what_is(n);
   ll digits = get_digits(n);
   if (digits == 1) {
     return mp[n] = n;
   }
   else {
     ll last_ones = digits / 2;
     ll num2 = keep(n, digits / 2) + 1, ans = 1e18;
     ll rev = reverse_num(num2);
     if (rev >= n) {
       ans = min(ans, get_ans(n - 1) + 1);
     }
     else {
       ans = min(ans, get_ans(rev) + n - num2);
     }
     return mp[n] = ans;
   }
 }
 
 int main () {
   std::ios::sync_with_stdio(false);
   ll t;
   cin >> t;
   for (ll i = 0; i < t; i++) {
     ll n, ans = 1e15;
     cin >> n;
     cout << "Case #" << i + 1 << ": " << get_ans(n) << endl;
   }
   return 0;
 }
