#include <iostream>
 #include <vector>
 #include <string>
 #include <algorithm>
 
 class ratatouille {
 	private:
 		int n, p;
 		std::vector<int> req;
 		std::vector<std::vector<int> > psz;
 
 		int sol;
 
 		int minserv(int rq, int sz) {
 			int l = 0, r = 3 * sz, m = 0;
 			while (l < r - 1) {
 				m = l + (r - l) / 2;
 				if (m * rq * 11 >= sz * 10) {
 					r = m;
 				} else {
 					l = m;
 				}
 			}
 			return r;
 		}
 
 		int maxserv(int rq, int sz) {
 			int l = 0, r = 3 * sz, m = 0;
 			while (l < r - 1) {
 				m = l + (r - l) / 2;
 				if (m * rq * 9 <= sz * 10) {
 					l = m;
 				} else {
 					r = m;
 				}
 			}
 			return l;
 		}
 
 	public:
 		void input(std::istream &is) {
 			is >> n >> p;
 			req.reserve(n);
 			int x;
 			for (int i = 0; i < n; ++i) {
 				is >> x;
 				req.push_back(x);
 			}
 			psz.resize(n);
 			for (int i = 0; i < n; ++i) {
 				psz.at(i).reserve(p);
 				for (int j = 0; j < p; ++j) {
 					is >> x;
 					psz.at(i).push_back(x);
 				}
 			}
 		}
 
 		void solve() {
 			sol = 0;
 			for (unsigned i = 0; i < psz.size(); ++i) {
 				std::sort(psz.at(i).begin(), psz.at(i).end());
 			}
 			std::vector<int> mins, maxs;
 			mins.resize(psz.size(), -1);
 			maxs.resize(psz.size(), -1);
 			while (true) {
 				int mv = 0, mi = -1;
 				for (unsigned i = 0; i < psz.size(); ++i) {
 					if (psz.at(i).size() <= 0) {
 						return;
 					}
 					maxs.at(i) = maxserv(req.at(i), psz.at(i).back());
 					if (maxs.at(i) <= 0) {
 						return;
 					}
 					if (maxs.at(i) > mv) {
 						mv = maxs.at(i);
 						mi = i;
 					}
 					mins.at(i) = minserv(req.at(i), psz.at(i).back());
 				}
 				int lb = 1;
 				int ub = mv;
 				for (unsigned i = 0; i < psz.size(); ++i) {
 					lb = std::max(lb, mins.at(i));
 					ub = std::min(ub, maxs.at(i));
 				}
 				if (lb <= ub) {
 					++sol;
 					for (unsigned i = 0; i < psz.size(); ++i) {
 						psz.at(i).pop_back();
 					}
 				} else {
 					psz.at(mi).pop_back();
 				}
 			}
 		}
 
 		void output(std::ostream &os) {
 			os << sol;
 		}
 };
 
 int main(void) {
 	int znj;
 	std::cin >> znj;
 	for (int i = 0; i < znj; ++i) {
 		ratatouille task;
 		task.input(std::cin);
 		task.solve();
 		std::cout << "Case #" << (i + 1) << ": ";
 		task.output(std::cout);
 		std::cout << std::endl;
 	}
 }
