#include <bits/stdc++.h>
 
 struct Item {
 	int min, max;
 };
 
 bool find(int n, int nPacks, int pack, const std::vector<std::vector<Item>> &packs, std::vector<std::vector<bool>> &used) {
 	std::vector<int> isGood(n, -1);
 	for (int ing = 1; ing < n; ing++) {
 		for (int p = 0; p < nPacks; p++) {
 			if (used[ing][p]) {
 				continue;
 			}
 			if (packs[ing][p].min <= pack && pack <= packs[ing][p].max) {
 				isGood[ing] = p;
 				continue;
 			}
 		}
 		if (isGood[ing] == -1) {
 			return false;
 		}
 	}
 	for (int j = 1; j < (int)isGood.size(); j++) {
 		used[j][isGood[j]] = true;
 	}
 	return true;
 }
 
 int solve() {
 	int n, nPacks; scanf("%d %d", &n, &nPacks);
 	std::vector<int> need(n);
 	for (int i = 0; i < n; i++) {
 		scanf("%d", &need[i]);
 	}
 	std::vector<std::vector<Item>> packs(n, std::vector<Item>(nPacks));
 	for (int i = 0; i < n; i++) {
 		for (int j = 0; j < nPacks; j++) {
 			int t; scanf("%d", &t);
 			int min = ceil(1. * t / (need[i] * 1.1));
 			int max = int(1. * t / (need[i] * 0.9));
 			packs[i][j] = Item{min, max};
 		}
 	}
 	std::vector<std::vector<bool>> used(n, std::vector<bool>(nPacks, false));
 	
 	int ans = 0;
 	for (int i = 0; i < nPacks; i++) {
 		bool isFind = false;
 		for (int pack = packs[0][i].min; pack <= packs[0][i].max; pack++) {
 			if (find(n, nPacks, pack, packs, used)) {
 				isFind = true;
 				break;
 			}
 		}
 		if (isFind) {
 			ans++;
 		}
 	}
 	return ans;
 }
 
 int main() {
 	int q; scanf("%d", &q);
 	
 	for (int i = 1; i <= q; i++) {
 		printf("Case #%d: %d\n", i, solve());
 	}
 
 	return 0;
 }
