#include <algorithm>
 #include <cmath>
 #include <iostream>
 #include <utility>
 #include <vector>
 
 using Ingrs = std::vector<double>;
 
 /** Size and availability.
  */
 using Pack = std::pair<double, bool>;
 using Packs = std::vector<Pack>;
 using All_packs = std::vector<Packs>;
 
 size_t get_max_kits(const Ingrs& ingrs, All_packs& all_packs)
 {
     size_t count = 0;
     size_t n_ingrs = ingrs.size();
 
     for (auto& i : all_packs) {
         sort(i.begin(), i.end(),
             [](const Pack& i, const Pack& j) { return i.first < j.first; });
     }
 
     for (size_t p_ingr = 0; p_ingr < n_ingrs; ++p_ingr) {
         for (Pack& pivot : all_packs[p_ingr]) {
             if (!pivot.second)
                 continue;
             int central_n_serving = std::round(pivot.first / ingrs[p_ingr]);
 
             for (int n_serving : { central_n_serving, central_n_serving + 1,
                      central_n_serving - 1 }) {
 
                 std::vector<Pack*> matched{};
                 for (size_t ingr = 0; ingr < n_ingrs; ++ingr) {
 
                     Packs& packs = all_packs[ingr];
                     double desired = n_serving * ingrs[ingr];
 
                     auto lower = std::lower_bound(packs.begin(), packs.end(),
                         0.9 * desired,
                         [](const Pack& pack, const double& bound) {
                             return pack.first < bound;
                         });
                     if (lower == packs.end())
                         break;
                     auto higher = std::upper_bound(packs.begin(), packs.end(),
                         1.1001 * desired,
                         [](const double& bound, const Pack& pack) {
                             return bound < pack.first;
                         });
 
                     double best_dev;
                     Pack* best = nullptr;
                     for (; lower != higher; ++lower) {
                         if (lower->second) {
                             double curr_dev = std::fabs(lower->first - desired);
                             if (best == nullptr || curr_dev < best_dev) {
                                 best_dev = curr_dev;
                                 best = &(*lower);
                             }
                         }
                     }
 
                     if (best == nullptr) {
                         break;
                     } else {
                         matched.push_back(best);
                     }
                 }
 
                 if (matched.size() == n_ingrs) {
                     ++count;
                     for (auto i : matched) {
                         i->second = false;
                     }
                 }
             }
         }
     }
 
     return count;
 }
 
 int main()
 {
     int n_cases;
 
     std::cin >> n_cases;
     for (size_t case_idx = 0; case_idx < n_cases; ++case_idx) {
         int n_ingrs;
         std::cin >> n_ingrs;
         int n_packs;
         std::cin >> n_packs;
 
         Ingrs ingrs(n_ingrs);
         for (size_t i = 0; i < n_ingrs; ++i) {
             std::cin >> ingrs[i];
         }
 
         All_packs all_packs(n_ingrs);
         for (size_t i = 0; i < n_ingrs; ++i) {
             for (size_t j = 0; j < n_packs; ++j) {
                 double curr;
                 std::cin >> curr;
                 all_packs[i].emplace_back(curr, true);
             }
         }
 
         auto res = get_max_kits(ingrs, all_packs);
 
         std::cout << "Case #" << case_idx + 1 << ": " << res << std::endl;
     }
 
     return 0;
 }
