#include <iostream>
 #include <cstdlib>
 #include <stdio.h>
 #include <vector>
 #include <list>
 #include <map>
 #include <set>
 #include <string.h>
 #include <algorithm>
 #include <math.h>
 
 typedef long long int LL;
 
 using namespace std;
 
 int main()
 {
     FILE* in, *out;
     string filename = "B-small-attempt3";
     string infilename = filename, outfilename = filename;
     infilename+=".in";
     outfilename+=".out";
     if((in=fopen(infilename.c_str(), "rt"))==NULL)
     {
         cout<<"Input file not found."<<endl;
         getchar();
         return 1;
     }
     if((out=fopen(outfilename.c_str(), "wt"))==NULL)
     {
         cout<<"Cannot create output file."<<endl;
         getchar();
         return 2;
     }
 
     int T;
     fscanf(in, "%d", &T);
 
     for(int t=0; t!=T; ++t)
     {
         int n, p;
         fscanf(in, "%d %d", &n, &p);
 		vector<int> r(n);
 		for(int i=0; i<n; ++i)
 		{
 			fscanf(in, "%d", &r[i]);
 		}
 		vector<vector<int> > kit(n, vector<int>(p));
 		vector<vector<int> > minpcs(n, vector<int>(p));
 		vector<vector<int> > maxpcs(n, vector<int>(p));
 		for(int i=0; i<n; ++i)
 		{
 			for(int j=0; j<p; ++j)
             {
                 fscanf(in, "%d", &kit[i][j]);
                 double actmin = (double)kit[i][j] / ((double) r[i] * 1.1);
                 actmin = ceil(actmin-0.0000001);
                 minpcs[i][j] = (int) actmin;
                 double actmax = (double)kit[i][j] / ((double) r[i] * 0.9);
                 actmax = floor(actmax+0.0000001);
                 maxpcs[i][j] = (int) actmax;
                 if(actmax < actmin)
                 {
                     minpcs[i][j] = -1;
                     maxpcs[i][j] = -1;
                 }
             }
 		}
 		bool stopping = false;
 		int kitnum = 0;
 		while(!stopping)
         {
             int actmin = -1, actmax = -1;
             int bestIdxI=-1;
             int bestIdxJ=-1;
             for(int i=0; i<n; ++i)
             {
                 for(int j=0; j<p; ++j)
                 {
                     if(minpcs[i][j]!=-1)
                     {
                         if(bestIdxI == -1 || maxpcs[i][j]<actmax || maxpcs[i][j]==actmax && minpcs[i][j]<actmin)
                         {
                             bestIdxI = i;
                             bestIdxJ = j;
                             actmax = maxpcs[i][j];
                             actmin = minpcs[i][j];
                         }
                     }
                 }
             }
             if(bestIdxI == -1)
                 break;
 
             maxpcs[bestIdxI][bestIdxJ] = -1;
             minpcs[bestIdxI][bestIdxJ] = -1;
 
             vector<int> bests(n);
             bests[bestIdxI]= bestIdxJ;
 
             bool haveAll  = true;
             for(int i=0; i<n; ++i)
             {
                 if(i == bestIdxI)
                     continue;
                 int bestmax = -1;
                 int bestmin = -1;
                 for(int j=0; j<p; ++j)
                 {
                     if(maxpcs[i][j]==-1)
                         continue;
 
                     if(minpcs[i][j]<=actmax && maxpcs[i][j]>=actmin)
                     {
                         if(bestmax == -1 || actmax < bestmax || actmax == bestmax && actmin > bestmin)
                         {
                             bestmax = actmax;
                             bestmin = actmin;
                             bests[i]=j;
                         }
                     }
                 }
                 if(bestmax == -1)
                 {
                     haveAll = false;
                     break;
                 }
                 actmax = min(actmax, maxpcs[i][bests[i]]);
                 actmin = min(actmin, minpcs[i][bests[i]]);
             }
             if(haveAll)
             {
                 for(int i=0; i<n; ++i)
                 {
                     minpcs[i][bests[i]]=-1;
                     maxpcs[i][bests[i]]=-1;
                 }
                 ++kitnum;
             }
         }
 
         fprintf(out, "Case #%d: %d\n", t+1, kitnum);
     }
 
     fclose(in);
     fclose(out);
     return 0;
 }
