#include <iostream>
 #include <cstdio>
 #include <fstream>
 #include <string>
 #include <map>
 #include <set>
 #include <vector>
 #include <deque>
 #include <queue>
 #include <stack>
 #include <tuple>
 #include <algorithm>
 #include <iterator>
 #include <functional>
 #include <cmath>
 #include <math.h>
 #include <time.h>
 #include <iomanip>
 
 using namespace std;
 
 typedef long long ll;
 typedef unsigned long long ull;
 typedef long double ld;
 
 const double Pi = 3.14159265359;
 const string alphabet = "abcdefghijklmnopqrstuvwxyz";
 
 namespace Helpers {
 	class Help {
 	public:
 		static bool is_prime(const ll& n) {
 			for (ll i = 2; i*i <= n; i++)
 				if (n%i == 0)
 					return false;
 			return true;
 		}
 
 		static ll gcd(const ll& a, const ll& b) {
 			return b ? gcd(b, a % b) : a;
 		}
 
 		static ll gcdex(ll a, ll b, ll & x, ll & y) {
 			if (a == 0) {
 				x = 0; y = 1;
 				return b;
 			}
 			ll x1, y1;
 			ll d = gcdex(b%a, a, x1, y1);
 			x = y1 - (b / a) * x1;
 			y = x1;
 			return d;
 		}
 
 		static ll fibonacci(ll n) {
 			fibnums.resize(n + 1, -1);
 			return fibonacci_core(n);
 		}
 
 		static ll kmp(const std::string& sMain, const std::string& sFind) {
 			std::vector<ll> vPrefix(sMain.size(), 0);
 			// prefix
 			for (ll i = 1; i < sMain.size(); i++) {
 				ll k = vPrefix[i - 1];
 				while (k > 0 && sMain[i] != sMain[k])
 					k = vPrefix[k];
 				if (sMain[i] == sMain[k])
 					k++;
 				vPrefix[i] = k;
 			}
 			// kmp
 			ll answer = -1;
 			ll k = 0;
 			for (ll i = 0; i < sMain.length(); i++) {
 				while (k > 0 && sMain[i] != sFind[k])
 					k = vPrefix[k - 1];
 				if (sMain[i] == sFind[k])
 					k++;
 				if (k == sFind.size()) {
 					answer = i - sFind.size() + 1;
 					break;
 				}
 			}
 			return answer;
 		}
 
 		static ll combinations(ll n, ll k, ll mod) {
 			if (n < k) swap(n, k);
 
 			ll top = 1;
 			for (ll x = max(n - k, k) + 1; x <= n; x++)
 				top = (top*x) % mod;
 
 			ll bottom = 1;
 			for (ll x = 1; x <= min(n - k, k); x++)
 				bottom = (bottom*x) % mod;
 
 			ll x, y, g = gcdex(bottom, mod, x, y);
 
 			if (g != 1)	throw(L"COMBINATIONS FAILED!");
 
 			x = (x % mod + mod) % mod;
 
 			return (top * x) % mod;
 		}
 
 	private:
 		static vector<ll> fibnums;
 		static ll fibonacci_core(ll n) {
 			if (n == 0)
 				return 0;
 			if (n == 1 || n == 2)
 				return 1;
 
 			return fibnums[n] != -1 ? fibnums[n] : (fibnums[n] = fibonacci_core(n - 1) + fibonacci_core(n - 2));
 		}
 	};
 
 	vector<ll> Help::fibnums;
 }
 /*************************************************************************/
 /*************************************************************************/
 
 bool canTakeOne(int original1, int given1) {
 	vector<int> v1, v2;
 
 	{
 
 		double count = static_cast<double>(given1) / original1;
 
 		int left = static_cast<int> (count);
 
 		double ans = count / (static_cast<int>(count + 0.2));
 
 		int tmp1 = (static_cast<int>(count + 0.2));
 
 		for (int i = max(1, tmp1 - 2); i < tmp1 + 3; i++) {
 			double rest = static_cast<double>(given1) / i;
 			double resA = rest / original1;
 			if (resA <= 1.100001 && resA >= 0.899999) {
 				v1.push_back(i);
 			}
 		}
 	}
 
 	return !v1.empty();
 }
 
 bool canTake(int original1, int given1, int original2, int given2) {
 	vector<int> v1, v2;
 
 	{
 
 	double count = static_cast<double>(given1) / original1;
 
 	int left = static_cast<int> (count);
 
 	double ans = count / (static_cast<int>(count + 0.2));
 
 	int tmp1 = (static_cast<int>(count + 0.2));
 
 	for (int i = max(1, tmp1 - 2); i < tmp1 + 3; i++) {
 		double rest = static_cast<double>(given1) / i;
 		double resA = rest / original1;
 		if (resA <= 1.100001 && resA >= 0.899999) {
 			v1.push_back(i);
 		}
 	}
 	}
 
 	{
 		double count = static_cast<double>(given2) / original2;
 
 		int left = static_cast<int> (count);
 
 		double ans = count / (static_cast<int>(count + 0.2));
 
 		int tmp1 = (static_cast<int>(count + 0.2));
 
 		for (int i = max(1, tmp1 - 2); i < tmp1 + 3; i++) {
 			double rest = static_cast<double>(given2) / i;
 			double resA = rest / original2;
 			if (resA <= 1.100001 && resA >= 0.899999) {
 				v2.push_back(i);
 			}
 		}
 	}
 
 	for (auto a : v1) {
 		for (auto b : v2) {
 			if (a == b) {
 				return true;
 			}
 		}
 	}
 
 	return 0;
 }
 
 
 int main()
 {
 
 	ifstream fin("file.in");
 	ofstream fout("file.out");
 
 	int test_n;
 	fin >> test_n;
 	for (int test_i = 0; test_i < test_n; test_i++) {
 		int n, p, answer = 0;
 		fin >> n >> p;
 		vector<int> proportion(n);
 		vector<vector<int>> v(n, vector<int>(p, 0));
 		for (auto& e : proportion) fin >> e;
 		for (auto& row : v) for (auto& e : row) fin >> e;
 		for (auto& row : v) sort(row.begin(), row.end());
 
 		for (int i = 0; i < p; i++) {
 			int accum = 0;
 			vector<pair<int, int>> taken;
 			if (n == 1) {
 				answer += canTakeOne(proportion[0], v[0][i]);
 			}
 			else {
 				for (int j = 1; j < n; j++) {
 					for (int k = 0; k < p; k++) {
 						if (canTake(proportion[0], v[0][i], proportion[j], v[j][k])) {
 							accum++;
 							taken.push_back({ 0,i });
 							taken.push_back({ j, k });
 							break;
 						};
 					}
 					if (accum != j) {
 						break;
 					}
 				}
 				if (accum == n - 1) {
 					answer++;
 					for (auto e : taken) {
 						v[e.first][e.second] = 0;
 					}
 				}
 			}
 		}
 
 		fout << "Case #" << test_i + 1 << ": " << answer << endl;
 	}
 
 	return 0;
 }
