#include <iostream>
 #include <vector>
 #include <algorithm>
 
 #define create(x, y) x y = read <x>()
 
 using namespace std;
 
 inline void init()
 {
 	ios_base::sync_with_stdio(false);
 	cin.tie(0);
 }
 
 template <typename T>
 inline T read()
 {
 	T temp;
 	cin >> temp;
 	return temp;
 }
 
 template <typename X, typename T, typename Y>
 inline X readn(Y n)
 {
 	X temp(n);
 	generate(temp.begin(), temp.end(), read<T>);
 	return temp;
 }
 
 template <typename I, typename R, typename T>
 inline bool check(I &ingredients, R &recipe, T amount)
 {
 	for (int i = 0; i < recipe.size(); i++)
 		if ((double)recipe[i] * amount * 0.9 > (double)ingredients[i] || (double)recipe[i] * amount * 1.1 < (double)ingredients[i])
 			return false;
 	return true;
 }
 
 template <typename I, typename R>
 inline bool pack(I &ingredients, R &recipe)
 {
 	int amount = ingredients[0] / recipe[0];
 	if (check(ingredients, recipe, amount) || check(ingredients, recipe, amount + 1) || check(ingredients, recipe, amount - 1) || check(ingredients, recipe, amount + 2) || check(ingredients, recipe, amount - 2))
 		return true;
 	return false;
 }
 
 template <typename I, typename R>
 inline int max_i(I &ingredients, R &recipe)
 {
 	int m = 0;
 	for (int i = 1; i < ingredients.size(); i++)
 		if ((double)ingredients[i] / recipe[i] > (double)ingredients[m] / recipe[m])
 			m = i;
 	return m;
 }
 
 template <typename R, typename I>
 inline bool make(R &recipe, I &ingredients)
 {
 	while (true)
 	{
 		for (auto i : ingredients)
 			if (i.empty())
 				return false;
 		vector <int> to_pack;
 		for (auto i : ingredients)
 			to_pack.push_back(i.back());
 		if (pack(to_pack, recipe))
 		{
 			for (auto&& i : ingredients)
 				i.pop_back();
 			return true;
 		}
 		else
 			ingredients[max_i(to_pack, recipe)].pop_back();
 	}
 }
 
 template <typename T>
 inline void Case(T case_number)
 {
 	create(short, n);
 	create(short, p);
 	vector <int> recipe(n);
 	recipe = readn <vector <int>, int>(n);
 	vector <vector <int> > ingredients(n);
 	for (auto&& i : ingredients)
 	{
 		i = readn <vector <int>, int>(p);
 		sort(i.begin(), i.end());
 	}
 	int answer = 0;
 	while (make(recipe, ingredients))
 		answer++;
 	cout << "Case #" << case_number << ": " << answer << '\n';
 }
 
 int main()
 {
 	init();
 	create(short, t);
 	for (short i = 1; i <= t; i++)
 		Case(i);
 	return 0;
 }