#include <bits/stdc++.h>
 using namespace std;
 
 const int s = 0;
 const int t = 1000;
 const int maxn = 1005;
 const int inf = 1 << 20;
 
 int T, n, p;
 int a[55];
 int q[55][55];
 int r[55];
 int graph[1005][1005];
 int used[1005];
 int match[55];
 int from[1005];
 
 
 bool solve(int v) {
 	for (auto to : graph[v]) {
 		if (used[to]) continue;
 		used[to] = 1;
 		if (match[to] == -1 || solve(match[to])) {
 			match[to] = v;
 			return true;
 		}
 	}
 	return false;
 }
 
 int get() {
 	memset(used, 0, sizeof used);
 	memset(from, -1, sizeof from);
 	queue<int> q;
 	q.push(s);
 	used[s] = 1;
 	int v;
 	while (!q.empty()) {
 		v = q.front(); q.pop();
 		for (int to = 1; to < maxn; to++) if (!used[to] && graph[v][to] > 0) {
 			used[to] = 1;
 			from[to] = v;
 			if (to == t) break;
 			q.push(to);
 		}
 	}
 	v = t;
 	int ret = inf;
 	while (from[v] > -1) {
 		int p = from[v];
 		ret = min(ret, graph[p][v]);
 		v = p;
 	}
 	if (ret == inf) return 0;
 	v = t;
 	while (from[v] > -1) {
 		int p = from[v];
 		graph[p][v] -= ret;
 		graph[v][p] += ret;
 		v = p;
 	}
 	return ret;
 }
 
 int maxflow() {
 	int ret = 0;
 	while (true) {
 		int flow = get();
 		if (flow == 0) break;
 		ret += flow;
 	}
 	return ret;
 }
 
 int ok() {
 	int ret = 0;
 	for (int j = 0; j < p; j++) {
 		for (int it = 0; it < 3; it++) {
 			int times = q[0][j] / r[0] + 1 - it;
 			if (r[0] * 110ll * times >= q[0][j] * 100ll && r[0] * 90ll * times <= q[0][j] * 100ll) ret++;
 		}
 	}
 	return ret;
 }
 
 int main() {
 	cin >> T;
 	for (int tc = 0; tc < T; tc++) {
 		cin >> n >> p;
 		for (int i = 0; i < 1005; i++) for (int j = 0; j < 1005; j++) graph[i][j] = 0;
 		memset(q, 0, sizeof q);
 		for (int i = 0; i < n; i++) cin >> r[i];
 		for (int i = 0; i < n; i++) for (int j = 0; j < p; j++) cin >> q[i][j];
 		int ans = 0;
 		if (n == 1) {
 			ans = ok();
 		} else {
 			for (int i = 0; i < n; i++) for (int j = 0; j < p; j++) {
 				set<int> havea;
 				for (int it = 0; it < 3; it++) {
 					int times = q[i][j] / r[i] + 1 - it;
 					if (times > -1 && r[i] * 110ll * times >= q[i][j] * 100ll && r[i] * 90ll * times <= q[i][j] * 100ll) havea.insert(times);
 				}
 				for (int ii = 0; ii < n; ii++) if (i != ii) {
 					for (int jj = 0; jj < p; jj++) {
 						set<int> haveb;
 						for (int it = 0; it < 3; it++) {
 							int times = q[ii][jj] / r[ii] + 1 - it;
 							if (times > -1 && r[ii] * 110ll * times >= q[ii][jj] * 100ll && r[ii] * 90ll * times <= q[ii][jj] * 100ll) haveb.insert(times);
 						}
 						for (auto it : havea) if (haveb.count(it)) {
 //							fprintf(stderr, "ing %d (size %d) matched with ing %d (size %d)\n", i, q[i][j], ii, q[ii][jj]);
 							if (i == 0) graph[s][p * i + j + 1] = 1;
 							graph[p * i + j + 1][p * ii + jj + 1] = 1;
 							graph[p * ii + jj + 1][p * i + j + 1] = 1;
 							if (i + 1 == n) graph[p * ii + jj + 1][t] = 1;
 						} 
 					}
 				}			 
 			}
 			ans = maxflow();
 		}
 		printf("Case #%d: %d\n", tc + 1, ans);
 	}
 	return 0;
 	
 }