#include <iostream>
 #include <vector>
 #include <algorithm>
 #include <utility>
 #include <cstring>
 using namespace std;
 
 int n, p;
 int needed[51];
 vector<pair<int,int> > parts[51];
 bool used[51][51];
 
 double eps=1e-9;
 
 pair<int,int> numserve(int num, int needed) {
 	int low=0, high=0;
 	for(int i=1000000;i>0;i--) {
 		if(needed*i*.9-eps<=num&&num<=needed*i*1.1+eps) {
 			if(high==0) high=i;
 			low=i;
 		}
 	}
 	return make_pair(low, high);
 }
 
 bool help(pair<int,int> a, pair<int,int> b) {
 	return a.second<b.second;
 }
 
 bool overlap(int low1, int high1, int low2, int high2) {
 	if(low2<low1) { swap(low1,low2); swap(high1,high2); }
 	return low1<=low2&&low2<=high1;
 }
 
 void solve(int tc) {
 	cin>>n>>p;
 	memset(used,0,sizeof(used));
 	for(int i=0;i<n;i++) cin>>needed[i];
 	for(int i=0;i<n;i++) {
 		parts[i]=vector<pair<int,int> >();
 		int a;
 		for(int j=0;j<p;j++) {
 			cin>>a;
 			pair<int,int> b=numserve(a,needed[i]);
 			if(b.first>0) parts[i].push_back(b);
 		}
 		sort(parts[i].begin(),parts[i].end(), help);
 	}
 	vector<int> idxs(n);
 
 	int ret=0;
 	for(int i=0;i<parts[0].size();i++) {
 		bool nomatch=false;
 		for(int j=1;j<n;j++) {
 			bool match=false;
 			for(int k=0;k<parts[j].size();k++) {
 				if(!used[j][k]&&overlap(parts[j][k].first,parts[j][k].second,parts[0][i].first,parts[0][i].second)) {
 					used[j][k]=true;
 					match=true;
 					break;
 				}
 			}
 			if(!match) nomatch=true;
 		}
 		if(!nomatch) ret++;
 	}
 	cout<<"Case #"<<tc<<": "<<ret<<endl;
 }
 
 int main() {
 	int cases;
 	cin>>cases;
 	for(int i=1;i<=cases;i++) solve(i);
 }
