#include <cstdio>
 #include <algorithm>
 #include <cstring>
 
 using namespace std;
 
 const int maxn = 50;
 int n, p;
 int mat[maxn+5][maxn+5];
 int l[maxn+5][maxn+5];
 int r[maxn+5][maxn+5];
 bool used[maxn+5][maxn+5];
 int v[maxn+5];
 
 int left(int x, int y) {
   return (10 * x + 11 * y - 1) / (11 * y);
 }
 
 int right(int x, int y) {
   return 10 * x / (9 * y);
 }
 
 bool dfs(int i, int x) {
   if(i == n)
     return true;
   int lbound = lower_bound(r[i], r[i] + p, x) - r[i];
   int rbound = upper_bound(l[i], l[i] + p, x) - l[i];
   bool ret = false;
   for(int j = lbound; j < rbound; j++) {
     if(used[i][j])
       continue;
     if(dfs(i+1, x)) {
       ret = true;
       used[i][j] = true;
       break;
     }
   }
   return ret;
 }
 
 int main() {
   int tc;
   scanf("%d", &tc);
   for(int kase = 1; kase <= tc; kase++) {
     scanf("%d%d", &n, &p);
     for(int i = 0; i < n; i++)
       scanf("%d", &v[i]);
     for(int i = 0; i < n; i++) {
       for(int j = 0; j < p; j++)
 	scanf("%d", &mat[i][j]);
       sort(mat[i], mat[i] + p);
     }
     for(int i = 0; i < n; i++) {
       for(int j = 0; j < p; j++) {
 	l[i][j] = left(mat[i][j], v[i]);
 	r[i][j] = right(mat[i][j], v[i]);
       }
     }
     memset(used, false, sizeof used);
     int ans = 0;
     for(int j = 0; j < p; j++) {
       for(int cnt = l[0][j]; cnt <= r[0][j]; cnt++) {
 	if(dfs(1, cnt)) {
 	  ans++;
 	}
       }
     }
     printf("Case #%d: %d\n", kase, ans);
   }
   return 0;
 }
