#include <iostream>
 #include <string>
 #include <cmath>
 #include <queue>
 #include <stack>
 #include <set>
 #include <map>
 #include <iterator>
 #include <functional>
 #include <vector>
 #include <algorithm>
 #include <unordered_map>
 
 using namespace std;
 
 int ones(const vector<vector<int> >& a)
 {
 	int n = a.size(), answer = 0;
 	for (int i = 0; i < n; ++i)
 	for (int j = 0; j < n; ++j)
 		answer += a[i][j];
 	return answer;
 }
 
 bool subset(const vector<vector<int> >& b, const vector<vector<int> >& a)
 {
 	int n = a.size();
 	for (int i = 0; i < n; ++i)
 	for (int j = 0; j < n; ++j)
 		if (b[i][j] > a[i][j])return false;
 	return true;
 }
 
 int onebits(int x)
 {
 	int result = 0;
 	while (x)
 	{
 		if (x & 1)
 			++result;
 		x >>= 1;
 	}
 	return result;
 }
 
 bool is_valid(const vector<vector<int> >& a)
 {
 	int n = a.size();
 	map<int, int> q;
 	for (int i = 0; i < n; ++i)
 	{
 		int mask = 0;
 		for (int j = 0; j < n; ++j)
 		{
 			mask |= (a[i][j] << j);
 		}
 		++q[mask];
 	}
 
 	for (auto it : q)
 	{
 		if (onebits(it.first) != it.second)
 			return false;
 	}
 
 	return true;
 }
 
 void solve()
 {
 	int n; cin >> n;
 	vector<vector<int> > a(n, vector<int>(n));
 	for (int i = 0; i < n; ++i)
 	{
 		string s; cin >> s;
 		for (int j = 0; j < n; ++j)
 			a[i][j] = (s[j] == '1');
 	}
 
 	vector<vector<int> > b = a;
 
 	int answer = n * n;
 
 	for (int mask = 0; mask < (1 << (n * n)); ++mask)
 	{
 		for (int i = 0; i < n * n; ++i)
 			b[i / n][i % n] = !!(mask & (1 << i));
 
 		if (is_valid(b) && subset(a, b))
 			answer = min(answer, ones(b) - ones(a));
 	}
 
 	cout << answer << endl;
 }
 
 int main()
 {
 	//freopen("i:/input.txt", "rt", stdin);
 	//freopen("i:/input.out", "wt", stdout);
 
 	int T; cin >> T;
 	for (int t = 1; t <= T; ++t)
 	{
 		cout << "Case #" << t << ": ";
 		solve();
 	}
 	return 0;
 }