#include <stdio.h>
 #include <algorithm>
 #include <vector>
 #include <utility>
 
 using namespace std;
 typedef pair<int,int> p;
 typedef vector<p> v;
 
 FILE* in=fopen("D-large.in","r");
 FILE* out=fopen("out.txt","w");
 
 int n,bin[50];
 int group[50];
 int g2i[50];
 
 int find(int k)
 {
 	if(group[k]==k) return k;
 	return group[k]=find(group[k]);
 }
 
 void merge(int a,int b)
 {
 	int A=find(a);
 	int B=find(b);
 	int C=A<B?A:B;
 	group[A]=group[B]=C;
 }
 
 int flag=0;
 
 void DFS(v& V,v& A,v& B,int k,int n)
 {
 	if(k==n)
 	{
 		int i,x=0,y=0;
 		for(i=0;i<A.size();i++)
 		{
 			x+=A[i].first;
 			y+=A[i].second;
 		}
 		if(A.size() && x==y) flag=1;
 		return;
 	}
 	
 	B.push_back(V[k]);
 	DFS(V,A,B,k+1,n);
 	if(flag) return;
 	B.pop_back();
 	
 	A.push_back(V[k]);
 	DFS(V,A,B,k+1,n);
 	if(flag) return;
 	A.pop_back();
 }
 
 int need;
 
 void f(v& V)
 {
 	v A,B;
 	int x,y,i;
 	int size=V.size();
 	
 	flag=0;
 	DFS(V,A,B,0,size);
 	if(A.size()==size)
 	{
 		int sum=0;
 		for(i=0;i<size;i++) sum+=V[i].first;
 		need+=sum*sum;
 	}
 	else
 	{
 		f(A);
 		f(B);
 	}
 }
 
 int count(int n)
 {
 	return n?n%2+count(n/2):0;
 }
 
 void solve()
 {
 	int i,j,t,tw;
 	fscanf(in,"%d",&n);
 	for(i=0;i<n;i++)
 	{
 		group[i]=i;
 		bin[i]=0;
 		tw=1;
 		for(j=0;j<n;j++)
 		{
 			fscanf(in,"%1d",&t);
 			bin[i]+=tw*t;
 			tw*=2;
 		}
 	}
 	
 	for(i=0;i<n;i++) for(j=i+1;j<n;j++)
 	{
 		if(bin[i]&bin[j])
 		{
 			merge(i,j);
 		}
 	}
 	
 	int cnt=0,ans=0;
 	int visit[50]={};
 	int people[50]={};
 	int machine[50]={};
 	int BIN[50]={};
 	
 	for(i=0;i<n;i++)
 	{
 		int g=find(i);
 		if(!visit[g])
 		{
 			g2i[g]=cnt++;
 			visit[g]=1;
 		}
 		int ind=g2i[g];
 		BIN[ind]|=bin[i];
 		people[ind]++;
 	}
 	for(i=0;i<cnt;i++)
 	{
 		machine[i]=count(BIN[i]);
 	}
 	int dif=0;
 	for(i=0;i<cnt;i++) dif+=(people[i]-machine[i]);
 	for(i=cnt;i<cnt+dif;i++)
 	{
 		people[i]=0;
 		machine[i]=1;
 	}
 	cnt+=dif;
 	
 	
 	v V;
 	for(i=0;i<cnt;i++) V.push_back(make_pair(people[i],machine[i]));
 	
 	need=0;
 	f(V);
 	
 	int sum=0;
 	for(i=0;i<n;i++) sum+=count(bin[i]);
 	fprintf(out,"%d\n",need-sum);
 }
 
 int main()
 {
 	int i,t;
 	fscanf(in,"%d",&t);
 	for(i=1;i<=t;i++)
 	{
 		fprintf(out,"Case #%d: ",i);
 		solve();
 	}
 	return 0;
 }
